% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getAccrualDurationFromN}
\alias{getAccrualDurationFromN}
\title{Accrual Duration to Enroll Target Number of Subjects}
\usage{
getAccrualDurationFromN(
  nsubjects = NA_real_,
  accrualTime = 0L,
  accrualIntensity = NA_real_
)
}
\arguments{
\item{nsubjects}{The vector of target number of subjects.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}
}
\value{
A vector of accrual durations.
}
\description{
Obtains the accrual duration to enroll the target number
of subjects.
}
\examples{
getAccrualDurationFromN(nsubjects = c(20, 150), accrualTime = c(0, 3),
                        accrualIntensity = c(10, 20))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
