% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nbpower}
\alias{nbpower}
\title{Power for Negative Binomial Rate Ratio}
\usage{
nbpower(
  kMax = 1L,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  rateRatioH0 = 1,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  kappa1 = NA_real_,
  kappa2 = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  spendingTime = NA_real_,
  studyDuration = NA_real_,
  nullVariance = 0L
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified. The futility bounds are
non-binding for the calculation of critical values.}

\item{typeBetaSpending}{The type of beta spending. One of the following:
"sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock
type spending function, "sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and "none" for no
early futility stopping. Defaults to "none".}

\item{parameterBetaSpending}{The parameter value for the beta spending.
Corresponds to rho for "sfKD", and gamma for "sfHSD".}

\item{rateRatioH0}{Rate ratio under the null hypothesis.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{kappa1}{The dispersion parameter (reciprocal of the shape
parameter of the gamma mixing distribution) for the active treatment
group by stratum.}

\item{kappa2}{The dispersion parameter (reciprocal of the shape
parameter of the gamma mixing distribution) for the control group by
stratum.}

\item{lambda1}{The rate parameter of the negative binomial distribution
for the active treatment group by stratum.}

\item{lambda2}{The rate parameter of the negative binomial distribution
for the control group by stratum.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}

\item{studyDuration}{Study duration for fixed follow-up design.
Defaults to missing, which is to be replaced with the sum of
\code{accrualDuration} and \code{followupTime}. If provided,
the value is allowed to be less than the sum of \code{accrualDuration}
and \code{followupTime}.}

\item{nullVariance}{Whether to calculate the variance for log rate ratio
under the null hypothesis.}
}
\value{
An S3 class \code{nbpower} object with 4 components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The overall significance level.
\item \code{numberOfEvents}: The total number of events.
\item \code{numberOfDropouts}: The total number of dropouts.
\item \code{numbeOfSubjects}: The total number of subjects.
\item \code{exposure}: The total exposure.
\item \code{studyDuration}: The total study duration.
\item \code{information}: The maximum information.
\item \code{expectedNumberOfEvents}: The expected number of events.
\item \code{expectedNumberOfDropouts}: The expected number of dropouts.
\item \code{expectedNumberOfSubjects}: The expected number of subjects.
\item \code{expectedExposure}: The expected exposure.
\item \code{expectedStudyDuration}: The expected study duration.
\item \code{expectedInformation}: The expected information.
\item \code{accrualDuration}: The accrual duration.
\item \code{followupTime}: The follow-up duration.
\item \code{fixedFollowup}: Whether a fixed follow-up design is used.
\item \code{kMax}: The number of stages.
\item \code{rateRatioH0}: The rate ratio under the null hypothesis.
\item \code{rateRatio}: The rate ratio.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale.
\item \code{futilityBounds}: The futility boundaries on the Z-scale.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{futilityPerStage}: The probability for futility stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeFutility}: The cumulative probability for futility
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha spent.
\item \code{numberOfEvents}: The number of events.
\item \code{numberOfDropouts}: The number of dropouts.
\item \code{numberOfSubjects}: The number of subjects.
\item \code{exposure}: The exposure.
\item \code{analysisTime}: The average time since trial start.
\item \code{efficacyRateRatio}: The efficacy boundaries on the rate
ratio scale.
\item \code{futilityRateRatio}: The futility boundaries on the rate
ratio scale.
\item \code{efficacyP}: The efficacy boundaries on the p-value scale.
\item \code{futilityP}: The futility boundaries on the p-value scale.
\item \code{information}: The cumulative information.
\item \code{efficacyStopping}: Whether to allow efficacy stopping.
\item \code{futilityStopping}: Whether to allow futility stopping.
}
\item \code{settings}: A list containing the following input parameters:
\code{typeAlphaSpending}, \code{parameterAlphaSpending},
\code{userAlphaSpending}, \code{typeBetaSpending},
\code{parameterBetaSpending}, \code{allocationRatioPlanned},
\code{accrualTime}, \code{accuralIntensity},
\code{piecewiseSurvivalTime}, \code{kappa1}, \code{kappa2},
\code{lambda1}, \code{lambda2}, \code{gamma1}, \code{gamma2},
\code{spendingTime}, and \code{nullVariance}.
\item \code{byTreatmentCounts}: A list containing the following counts by
treatment group:
\itemize{
\item \code{numberOfEvents1}: The number of events by stage for
the treatment group.
\item \code{numberOfDropouts1}: The number of dropouts by stage for
the treatment group.
\item \code{numberOfSubjects1}: The number of subjects by stage for
the treatment group.
\item \code{exposure1}: The exposure by stage for the treatment group.
\item \code{numberOfEvents2}: The number of events by stage for
the control group.
\item \code{numberOfDropouts2}: The number of dropouts by stage for
the control group.
\item \code{numberOfSubjects2}: The number of subjects by stage for
the control group.
\item \code{exposure2}: The exposure by stage for the control group.
\item \code{expectedNumberOfEvents1}: The expected number of events for
the treatment group.
\item \code{expectedNumberOfDropouts1}: The expected number of dropouts
for the treatment group.
\item \code{expectedNumberOfSubjects1}: The expected number of subjects
for the treatment group.
\item \code{expectedExposure1}: The expected exposure for the treatment
group.
\item \code{expectedNumberOfEvents2}: The expected number of events for
control group.
\item \code{expectedNumberOfDropouts2}: The expected number of dropouts
for the control group.
\item \code{expectedNumberOfSubjects2}: The expected number of subjects
for the control group.
\item \code{expectedExposure2}: The expected exposure for the control
group.
}
}
}
\description{
Estimates the power for negative binomial rate ratio test.
}
\examples{
# Example 1: Variable follow-up design

nbpower(kMax = 2, informationRates = c(0.5, 1),
        alpha = 0.025, typeAlphaSpending = "sfOF",
        accrualIntensity = 1956/1.25,
        stratumFraction = c(0.2, 0.8),
        kappa1 = 5, kappa2 = 5,
        lambda1 = c(0.7*0.125, 0.75*0.25),
        lambda2 = c(0.125, 0.25),
        gamma1 = 0, gamma2 = 0,
        accrualDuration = 1.25,
        followupTime = 2.75, fixedFollowup = FALSE,
        nullVariance = 1)

# Example 2: Fixed follow-up design

nbpower(kMax = 2, informationRates = c(0.5, 1),
        alpha = 0.025, typeAlphaSpending = "sfOF",
        accrualIntensity = 220/1.5,
        kappa1 = 3, kappa2 = 3,
        lambda1 = 0.5*8.4, lambda2 = 8.4,
        gamma1 = 0, gamma2 = 0,
        accrualDuration = 1.5,
        followupTime = 0.5, fixedFollowup = TRUE)

}
\seealso{
\code{\link{nbstat}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
