% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsim2e3a}
\alias{lrsim2e3a}
\title{Log-rank test simulation for two endpoints and three arms}
\usage{
lrsim2e3a(
  kMax = NA_integer_,
  kMaxe1 = NA_integer_,
  hazardRatioH013e1 = 1,
  hazardRatioH023e1 = 1,
  hazardRatioH012e1 = 1,
  hazardRatioH013e2 = 1,
  hazardRatioH023e2 = 1,
  hazardRatioH012e2 = 1,
  allocation1 = 1L,
  allocation2 = 1L,
  allocation3 = 1L,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  rho = 0,
  lambda1e1 = NA_real_,
  lambda2e1 = NA_real_,
  lambda3e1 = NA_real_,
  lambda1e2 = NA_real_,
  lambda2e2 = NA_real_,
  lambda3e2 = NA_real_,
  gamma1e1 = 0L,
  gamma2e1 = 0L,
  gamma3e1 = 0L,
  gamma1e2 = 0L,
  gamma2e2 = 0L,
  gamma3e2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  plannedEvents = NA_integer_,
  plannedTime = NA_real_,
  maxNumberOfIterations = 1000L,
  maxNumberOfRawDatasetsPerStage = 0L,
  seed = NA_integer_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{kMaxe1}{Number of stages with timing determined by PFS events.
Ranges from 0 (none) to \code{kMax}.}

\item{hazardRatioH013e1}{Hazard ratio under the null hypothesis for arm 1
vs arm 3 for endpoint 1 (PFS). Defaults to 1 for superiority test.}

\item{hazardRatioH023e1}{Hazard ratio under the null hypothesis for arm 2
vs arm 3 for endpoint 1 (PFS). Defaults to 1 for superiority test.}

\item{hazardRatioH012e1}{Hazard ratio under the null hypothesis for arm 1
vs arm 2 for endpoint 1 (PFS). Defaults to 1 for superiority test.}

\item{hazardRatioH013e2}{Hazard ratio under the null hypothesis for arm 1
vs arm 3 for endpoint 2 (OS). Defaults to 1 for superiority test.}

\item{hazardRatioH023e2}{Hazard ratio under the null hypothesis for arm 2
vs arm 3 for endpoint 2 (OS). Defaults to 1 for superiority test.}

\item{hazardRatioH012e2}{Hazard ratio under the null hypothesis for arm 1
vs arm 2 for endpoint 2 (OS). Defaults to 1 for superiority test.}

\item{allocation1}{Number of subjects in Arm A in
a randomization block. Defaults to 1 for equal randomization.}

\item{allocation2}{Number of subjects in Arm B in
a randomization block. Defaults to 1 for equal randomization.}

\item{allocation3}{Number of subjects in Arm C in
a randomization block. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{rho}{The correlation coefficient for the standard bivariate normal
random variables used to generate time to disease progression and time
to death using the inverse CDF method.}

\item{lambda1e1}{A vector of hazard rates for the event in each analysis
time interval by stratum for arm 1 and endpoint 1 (PFS).}

\item{lambda2e1}{A vector of hazard rates for the event in each analysis
time interval by stratum for arm 2 and endpoint 1 (PFS).}

\item{lambda3e1}{A vector of hazard rates for the event in each analysis
time interval by stratum for arm 3 and endpoint 1 (PFS).}

\item{lambda1e2}{A vector of hazard rates for the event in each analysis
time interval by stratum for arm 1 and endpoint 2 (OS).}

\item{lambda2e2}{A vector of hazard rates for the event in each analysis
time interval by stratum for arm 2 and endpoint 2 (OS).}

\item{lambda3e2}{A vector of hazard rates for the event in each analysis
time interval by stratum for arm 3 and endpoint 2 (OS).}

\item{gamma1e1}{The hazard rate for exponential dropout. A vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for arm 1 and endpoint 1 (PFS).}

\item{gamma2e1}{The hazard rate for exponential dropout. A vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for arm 2 and endpoint 1 (PFS).}

\item{gamma3e1}{The hazard rate for exponential dropout. A vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for arm 3 and endpoint 1 (PFS).}

\item{gamma1e2}{The hazard rate for exponential dropout. A vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for arm 1 and endpoint 2 (OS).}

\item{gamma2e2}{The hazard rate for exponential dropout. A vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for arm 2 and endpoint 2 (OS).}

\item{gamma3e2}{The hazard rate for exponential dropout. A vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for arm 3 and endpoint 2 (OS).}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{plannedEvents}{The planned cumulative total number of PFS events at
Look 1 to Look \code{kMaxe1} for Arms A and C combined and the planned
cumulative total number of OS events at Look \code{kMaxe1+1} to Look
\code{kMax} for Arms A and C combined.}

\item{plannedTime}{The calendar times for the analyses. To use calendar
time to plan the analyses, \code{plannedEvents} should be missing.}

\item{maxNumberOfIterations}{The number of simulation iterations.
Defaults to 1000.}

\item{maxNumberOfRawDatasetsPerStage}{The number of raw datasets per
stage to extract. Defaults to 1.}

\item{seed}{The seed to reproduce the simulation results.
The seed from the environment will be used if left unspecified,}
}
\value{
A list with 2 components:
\itemize{
\item \code{sumdata}: A data frame of summary data by iteration and stage:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{eventsNotAchieved}: Whether the target number of events
is not achieved for the iteration.
\item \code{stageNumber}: The stage number, covering all stages even if
the trial stops at an interim look.
\item \code{analysisTime}: The time for the stage since trial start.
\item \code{accruals1}: The number of subjects enrolled at the stage for
the active treatment 1 group.
\item \code{accruals2}: The number of subjects enrolled at the stage for
the active treatment 2 group.
\item \code{accruals3}: The number of subjects enrolled at the stage for
the control group.
\item \code{totalAccruals}: The total number of subjects enrolled at
the stage.
\item \code{endpoint}: The endpoint (1 or 2) under consideration.
\item \code{events1}: The number of events at the stage for
the active treatment 1 group.
\item \code{events2}: The number of events at the stage for
the active treatment 2 group.
\item \code{events3}: The number of events at the stage for
the control group.
\item \code{totalEvents}: The total number of events at the stage.
\item \code{dropouts1}: The number of dropouts at the stage for
the active treatment 1 group.
\item \code{dropouts2}: The number of dropouts at the stage for
the active treatment 2 group.
\item \code{dropouts3}: The number of dropouts at the stage for
the control group.
\item \code{totalDropouts}: The total number of dropouts at the stage.
\item \code{logRankStatistic13}: The log-rank test Z-statistic
comparing the active treatment 1 to the control for the endpoint.
\item \code{logRankStatistic23}: The log-rank test Z-statistic
comparing the active treatment 2 to the control for the endpoint.
\item \code{logRankStatistic12}: The log-rank test Z-statistic
comparing the active treatment 1 to the active treatment 2
for the endpoint.
}
\item \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
positive integer): A data frame for subject-level data for selected
replications, containing the following variables:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{stageNumber}: The stage under consideration.
\item \code{analysisTime}: The time for the stage since trial start.
\item \code{subjectId}: The subject ID.
\item \code{arrivalTime}: The enrollment time for the subject.
\item \code{stratum}: The stratum for the subject.
\item \code{treatmentGroup}: The treatment group (1, 2, or 3) for
the subject.
\item \code{survivalTime1}: The underlying survival time for
event endpoint 1 for the subject.
\item \code{dropoutTime1}: The underlying dropout time for
event endpoint 1 for the subject.
\item \code{timeUnderObservation1}: The time under observation
since randomization for event endpoint 1 for the subject.
\item \code{event1}: Whether the subject experienced event endpoint 1.
\item \code{dropoutEvent1}: Whether the subject dropped out for
endpoint 1.
\item \code{survivalTime2}: The underlying survival time for
event endpoint 2 for the subject.
\item \code{dropoutTime2}: The underlying dropout time for
event endpoint 2 for the subject.
\item \code{timeUnderObservation2}: The time under observation
since randomization for event endpoint 2 for the subject.
\item \code{event2}: Whether the subject experienced event endpoint 2.
\item \code{dropoutEvent2}: Whether the subject dropped out for
endpoint 2.
}
}
}
\description{
Performs simulation for two-endpoint three-arm group
sequential trials based on weighted log-rank test. The first
\code{kMaxe1} looks are driven by the total number of PFS events in Arm A
and Arm C combined, and the subsequent looks are driven by the total
number of OS events in Arm A and Arm C combined. Alternatively,
the analyses can be planned to occur at specified calendar times.
}
\examples{

sim1 = lrsim2e3a(
  kMax = 3,
  kMaxe1 = 2,
  allocation1 = 2,
  allocation2 = 2,
  allocation3 = 1,
  accrualTime = c(0, 8),
  accrualIntensity = c(10, 28),
  piecewiseSurvivalTime = 0,
  rho = 0,
  lambda1e1 = log(2)/12*0.60,
  lambda2e1 = log(2)/12*0.70,
  lambda3e1 = log(2)/12,
  lambda1e2 = log(2)/30*0.65,
  lambda2e2 = log(2)/30*0.75,
  lambda3e2 = log(2)/30,
  accrualDuration = 30.143,
  plannedEvents = c(186, 259, 183),
  maxNumberOfIterations = 1000,
  maxNumberOfRawDatasetsPerStage = 1,
  seed = 314159)

head(sim1$sumdata)
head(sim1$rawdata)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
