% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{samplesizeOneRateExact}
\alias{samplesizeOneRateExact}
\title{Sample size for Poisson one-sample exact test}
\usage{
samplesizeOneRateExact(
  beta = 0.2,
  lambdaH0 = NA_real_,
  lambda = NA_real_,
  D = 1,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{lambdaH0}{The Poisson rate under the null hypothesis.}

\item{lambda}{The Poisson rate under the alternative hypothesis.}

\item{D}{The average exposure per subject.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
A data frame containing the critical value of the number of
events for rejecting the null hypothesis, the attained type I
error, the power for the exact test, the sample size,
the Poisson rates under the null and alternative hypotheses,
the average exposure, and the direction of the alternative.
}
\description{
Obtains the sample size for Poisson one-sample exact test.
}
\examples{
samplesizeOneRateExact(beta = 0.2, lambdaH0 = 0.2, lambda = 0.3,
                       D = 1, alpha = 0.05)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
