% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignANOVAContrast}
\alias{getDesignANOVAContrast}
\title{Power and sample size for one-way ANOVA contrast}
\usage{
getDesignANOVAContrast(
  beta = NA_real_,
  n = NA_real_,
  ngroups = 2,
  means = NA_real_,
  stDev = 1,
  contrast = NA_real_,
  meanContrastH0 = 0,
  allocationRatioPlanned = NA_real_,
  rounding = TRUE,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ngroups}{The number of treatment groups.}

\item{means}{The treatment group means.}

\item{stDev}{The common standard deviation.}

\item{contrast}{The coefficients for the single contrast.}

\item{meanContrastH0}{The mean of the contrast under the
null hypothesis.}

\item{allocationRatioPlanned}{Allocation ratio for the treatment
groups. It has length \code{ngroups - 1} or \code{ngroups}. If it is
of length \code{ngroups - 1}, then the last treatment group will
assume value 1 for allocation ratio.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
An S3 class \code{designANOVAContrast} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis for the
treatment contrast.
\item \code{alpha}: The one-sided significance level.
\item \code{n}: The number of subjects.
\item \code{ngroups}: The number of treatment groups.
\item \code{means}: The treatment group means.
\item \code{stDev}: The common standard deviation.
\item \code{contrast}: The coefficients for the single contrast.
\item \code{meanContrastH0}: The mean of the contrast under the null
hypothesis.
\item \code{meanContrast}: The mean of the contrast under the alternative
hypothesis.
\item \code{effectsize}: The effect size.
\item \code{allocationRatioPlanned}: Allocation ratio for the treatment
groups.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power and sample size for a single contrast
in one-way analysis of variance.
}
\examples{

(design1 <- getDesignANOVAContrast(
  beta = 0.1, ngroups = 4, means = c(1.5, 2.5, 2, 0),
  stDev = 3.5, contrast = c(1, 1, 1, -3)/3,
  allocationRatioPlanned = c(2, 2, 2, 1),
  alpha = 0.025))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
