% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.R
\name{lambda}
\alias{lambda}
\title{Compute a lambda sequence for the regularization path}
\usage{
lambda(x, y, intercept = TRUE, weights = NULL, grouping = NULL,
  groupWeights = NULL, parameterWeights = NULL, alpha = 1, d = 100L,
  lambda.min, lambda.min.rel = FALSE,
  algorithm.config = lsgl.standard.config)
}
\arguments{
\item{x}{design matrix, matrix of size \eqn{N \times p}.}

\item{y}{response matrix, matrix of size \eqn{N \times K}.}

\item{intercept}{should the model include intercept parameters.}

\item{weights}{sample weights, vector of size \eqn{N \times K}.}

\item{grouping}{grouping of features, a factor or vector of length \eqn{p}. Each element of the factor/vector specifying the group of the feature.}

\item{groupWeights}{the group weights, a vector of length \eqn{m} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{K \times p}.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{d}{the length of lambda sequence}

\item{lambda.min}{the smallest lambda value in the computed sequence.}

\item{lambda.min.rel}{is lambda.min relative to lambda.max ? (i.e. actual lambda min used is \code{lambda.min*lambda.max}, with \code{lambda.max} the computed maximal lambda value)}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
a vector of length \code{d} containing the compute lambda sequence.
}
\description{
Computes a decreasing lambda sequence of length \code{d}.
The sequence ranges from a data determined maximal lambda \eqn{\lambda_\textrm{max}} to the user inputed \code{lambda.min}.
}
\author{
Martin Vincent
}

