% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_param.R
\name{plot_param}
\alias{plot_param}
\title{boxplot of parameters of fitted LSIRM model}
\usage{
plot_param(data, lsrm_result, option, missing = 99)
}
\arguments{
\item{data}{matrix; binary item response matrix to be analyzed.}

\item{lsrm_result}{List; The output list obtained by any lsrm function.}

\item{option}{character; If value is "beta", draw the boxplot for the posterior samples of beta. If value is "theta", draw the distribution of the theta estimates per total test score for the \code{data}. If value is "alpha", draw the boxplot for the posterior samples of alpha. The "alpha" is only available for 2pl LSIRM.}

\item{missing}{Numeric; a number to replace missing values. default value is 99.}
}
\value{
\code{plot_param} returns the box plot of main effect parameters \eqn{\beta_i} and \eqn{\theta_j}. For item effect \eqn{\beta_i}, it shows the 95\% posterior credible intervals and for respondent effect \eqn{\theta_j}, it shows the distribution of the estimates per total sum of positive response.
}
\description{
\link{plot_param} is used to plot the main effect parameters fitted LSIRM model.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5),ncol=10,nrow=50)
lsirm_result <- lsirm1pl(data = data)
plot_param(data, lsirm_result, "theta")
plot_param(data, lsirm_result, "beta")
}
}
