% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramersV.R
\name{cramersV}
\alias{cramersV}
\title{Cramer's V}
\usage{
cramersV(...)
}
\arguments{
\item{...}{Arguments to be passed to the \code{chisq.test} function.}
}
\value{
A numeric variable with a single element corresponding to the
value of V.
}
\description{
Calculate the Cramer's V measure of association
}
\details{
Calculates the Cramer's V measure of effect size for chi-square
tests of association and goodness of fit. The arguments to the
\code{cramersV} function are all passed straight to the \code{chisq.test}
function, and should have the same format.
}
\examples{

# Consider an experiment with two conditions, each with 100
# participants. Each participant chooses between one of three
# options. Possible data for this experiment:

condition1 <- c(30, 20, 50)
condition2 <- c(35, 30, 35)
X <- cbind( condition1, condition2 )
rownames(X) <- c( 'choice1', 'choice2', 'choice3' )
print(X)

# To test the null hypothesis that the distribution of choices
# is identical in the two conditions, we would run a chi-square
# test:
chisq.test(X)

# To estimate the effect size we can use Cramer's V:
cramersV( X )  # returns a value of 0.159

}
