% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairedSamplesTTest.R
\name{pairedSamplesTTest}
\alias{pairedSamplesTTest}
\title{Paired samples t-test}
\usage{
pairedSamplesTTest(
  formula,
  data = NULL,
  id = NULL,
  one.sided = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{formula}{Formula specifying the outcome and the groups (required).}

\item{data}{Optional data frame containing the variables.}

\item{id}{The name of the id variable (must be a character string).}

\item{one.sided}{One sided or two sided hypothesis test (default = \code{FALSE})}

\item{conf.level}{The confidence level for the confidence interval (default = .95).}
}
\value{
An object of class 'TTest'. When printed, the output is organised
into five short sections. The first section lists the name of the test
and the variables included. The second provides means and standard
deviations. The third states explicitly what the null and alternative
hypotheses were. The fourth contains the test results: t-statistic,
degrees of freedom and p-value. The final section includes the relevant
confidence interval and an estimate of the effect size (i.e., Cohen's d)
}
\description{
Convenience function that runs a paired samples t-test. This
is a wrapper function intended to be used for pedagogical purposes only.
}
\details{
The \code{pairedSamplesTTest} function runs a paired-sample t-test,
and prints the results in a format that is easier for novices to handle than
the output of \code{t.test}. All the actual calculations are done by the
\code{t.test} and \code{cohensD} functions.

There are two different ways of specifying the formula, depending on whether
the data are in wide form or long form. If the data are in wide form, then
the input should be a one-sided formula of the form
\code{~ variable1 + variable2}. The \code{id} variable is not required: the
first element of \code{variable1} is paired with the first element of
\code{variable2} and so on. Both \code{variable1} and \code{variable2} must
be numeric.

If the data are in long form, a two sided formula is required. The simplest
way to specify the test is to input a formula of the form
\code{outcome ~ group + (id)}. The term in parentheses is assumed to be
the \code{id} variable, and must be a factor. The \code{group} variable
must be a factor with two levels (if there are more than two levels but
only two are used in the data, a warning is given). The \code{outcome}
variable must be numeric.

The reason for using the \code{outcome ~ group + (id)} format is that it is
broadly consistent with the way repeated measures analyses are specified
in the \code{lme4} package. However, this format may not appeal to some
people for teaching purposes. Given this, the \code{pairedSamplesTTest}
also supports a simpler formula of the form \code{outcome ~ group}, so
long as the user specifies the \code{id} argument: this must be a
character vector specifying the name of the id variable

As with the \code{t.test} function, the default test is two sided,
corresponding to a default value of \code{one.sided = FALSE}. To specify
a one sided test, the \code{one.sided} argument must specify the name of
the factor level (long form data) or variable (wide form data) that is
hypothesised (under the alternative) to have the larger mean. For instance,
if the outcome at "time2" is expected to be higher than at "time1", then
the corresponding one sided test is specified by \code{one.sided = "time2"}.
}
\examples{
# long form data frame
df <- data.frame(
  id = factor( x=c(1, 1, 2, 2, 3, 3, 4, 4),
               labels=c("alice","bob","chris","diana") ),
  time = factor( x=c(1,2,1,2,1,2,1,2),
                 labels=c("time1","time2")),
  wm = c(3, 4, 6, 6, 9, 12,7,9)
)

# wide form
df2 <- longToWide( df, wm ~ time )

# basic test, run from long form or wide form data
pairedSamplesTTest( formula= wm ~ time, data=df, id="id" )
pairedSamplesTTest( formula= wm ~ time + (id), data=df )
pairedSamplesTTest( formula= ~wm_time1 + wm_time2, data=df2 )

# one sided test
pairedSamplesTTest( formula= wm~time, data=df, id="id", one.sided="time2" )

# missing data because of NA values
df$wm[1] <- NA
pairedSamplesTTest( formula= wm~time, data=df, id="id" )

# missing data because of missing cases from the long form data frame
df <- df[-1,]
pairedSamplesTTest( formula= wm~time, data=df, id="id" )

}
\seealso{
\code{\link{t.test}},
\code{\link{oneSampleTTest}},
\code{\link{independentSamplesTTest}},
\code{\link{cohensD}}
}
