% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vc.R
\name{vc}
\alias{vc}
\alias{vc.default}
\alias{vc.asreml}
\alias{vc.lme}
\alias{vc.glmerMod}
\alias{vc.lmerMod}
\alias{vc.mcmc.list}
\title{Extract variance components from mixed models}
\usage{
vc(object, ...)

\method{vc}{default}(object, ...)

\method{vc}{asreml}(object, gamma = FALSE, ...)

\method{vc}{lme}(object, ...)

\method{vc}{glmerMod}(object, ...)

\method{vc}{lmerMod}(object, ...)

\method{vc}{mcmc.list}(object, quantiles = c(0.025, 0.5, 0.975), ...)
}
\arguments{
\item{object}{A fitted model object}

\item{...}{Not used. Extra arguments.}

\item{gamma}{If gamma=FALSE, then the 'gamma' column is omitted from the
results from asreml}

\item{quantiles}{The quantiles to use for printing mcmc.list objects}
}
\value{
A data frame or other object.
}
\description{
Extract the variance components from a fitted model.  Currently supports
\code{asreml}, \code{lme4}, \code{nlme} and \code{mcmc.list} objects.
}
\details{
The extracted variance components are stored in a data frame with an
additional 'vc.xxx' class that has an associated print method.
}
\examples{

\dontrun{

require("nlme")
data(Rail)
m3 <- lme(travel~1, random=~1|Rail, data=Rail)
vc(m3)
##       effect variance stddev
##  (Intercept)   615.3  24.81
##     Residual    16.17  4.021

require("lme4")
m4 <- lmer(travel~1 + (1|Rail), data=Rail)
vc(m4)
##      grp        var1 var2   vcov  sdcor
##     Rail (Intercept) <NA> 615.3  24.81
## Residual        <NA> <NA>  16.17  4.021 

require("asreml")
ma <- asreml(travel~1, random=~Rail, data=Rail)
vc(ma)
##         effect component std.error z.ratio constr
##  Rail!Rail.var    615.3      392.6     1.6    pos
##     R!variance     16.17       6.6     2.4    pos

# See vignette for rjags example

# To change the number of digits, use the print function.
print(vc(m3), dig=5)

}

}
