% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/allowNeighb.R
\name{allowNeighb}
\alias{allowNeighb}
\title{Implement neighbourhood decision rules}
\usage{
allowNeighb(neighb, x, categories, rules, ...)
}
\arguments{
\item{neighb}{a NeighbRasterStack object}

\item{x}{a categorical RasterLayer to which neighbourhood rules should be
applied. If \code{neighb} is supplied it is updated with this map}

\item{categories}{numeric vector containing land use categories. If
\code{allowNeighb} is called from an allocation model this argument
should contain all categories in the simulation, regardless of whether
they're associated with a neighbourhood decision rule}

\item{rules}{a numeric vector with neighbourhood decision rules. Each rule
is a value between 0 and 1 representing the threshold neighbourhood value
above which change is allowed. Rules should correspond with
\code{x@categories}}

\item{\dots}{additional arguments (none)}
}
\value{
A matrix.
}
\description{
Identify legitimate transitions for each cell according to neighbourhood
decision rules.
}
\examples{
## Plum Island Ecosystems

## load observed land use data
obs <- ObsLulcRasterStack(x=pie,
                     pattern="lu",
                     categories=c(1,2,3),
                     labels=c("forest","built","other"),
                     t=c(0,6,14))

## create a NeighbRasterStack object for forest only
w <- matrix(data=1, nrow=3, ncol=3)
nb <- NeighbRasterStack(x=obs[[1]], weights=w, categories=1)

## only allow change to forest within neighbourhood of current forest cells
## note that rules can be any value between zero (less restrictive) and one
## (more restrictive)
nb.allow <- allowNeighb(neighb=nb,
                        x=obs[[1]],
                        categories=obs@categories,
                        rules=0.5)

## create raster showing cells allowed to change to forest
r <- obs[[1]]
r[!is.na(r)] <- nb.allow[,1]
plot(r)

## NB output is only useful when used within an allocation routine
}
\seealso{
\code{\link{allow}}, \code{\link{NeighbRasterStack}}
}

