% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lumberjack.R
\name{\%>>\%}
\alias{\%>>\%}
\alias{\%L>\%}
\title{The lumberjack operator}
\usage{
lhs \%>>\% rhs

lhs \%L>\% rhs
}
\arguments{
\item{lhs}{Input value}

\item{rhs}{Function call or 'dotted' expression (see below). 
as value}
}
\description{
A not-a-pipe operator that logs
}
\section{Piping}{


The operators \code{\%>>\%} and \code{\%L>\%} are synonyms. The \code{\%L>\%}
can be used to avoid confusion with the \code{\%>>\%} operator of the
\code{pipeR} package.

The lumberjack operator behaves more or less as a simplified version of the 
\code{magrittr} pipe operator. The basic behavior of \code{lhs \%>>\% rhs} is
the following:

\itemize{
 \item{If the \code{rhs} uses dot-variables (\code{.}), these are interpreted
 as the left-hand side, except in formulas where dots already have a special 
 meaning.}
 \item{If the \code{rhs} is a function call, with no dot-variables used, the
 \code{lhs} is used as its first argument.}
}
The most notable differences with `magrittr` are the following.
\itemize{
  \item{ it does not allow you to define functions in the magrittr style,
  like \code{a <- . \%>\% sin(.) } 
  }
  \item{there is no assignment-pipe like \code{\%<>\%}.}
}
}

\section{Logging}{


If the left-hand-side is tagged for logging, the lumberjack will update the 
log by calling the logger's \code{$add()} method, with arguments \code{meta},
\code{input}, \code{output}. Here, \code{meta} is a list with information on
the operations performed, and input and output are the left-hand-side and the
result, respectively (See also: \href{../doc/extending.html}{extending
lumberjack}).
}

\examples{
# pass arguments to a function
1:3 \%>>\% mean()

# pass arguments using "."
TRUE \%>>\% mean(c(1,NA,3), na.rm = .)

# pass arguments to an expression, using "."
1:3 \%>>\% { 3 * .}

# in a more complicated expression, return "." explicitly
women \%>>\% { .$height <- 2*.$height; . }



}
