% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run_file}
\alias{run_file}
\title{Run a file while tracking changes in data}
\usage{
run_file(file, auto_dump = TRUE)
}
\arguments{
\item{file}{\code{[character]} file to run.}

\item{auto_dump}{\code{[logical]} Toggle automatically dump all remaining logs
after executing \code{file}.}
}
\value{
An environment.
}
\description{
Run all code in a file. Changes in data that are tracked, (e.g.  with
\code{\link{start_log}(data)}) will be followed by the assigned loggers.
}
\section{Details}{

All code in \code{file} is executed in a new environment with
\code{.GlobalEnv} as a parent.
}

\examples{
# using 'dontrun'
\dontrun{
# create an R file, with logging.
script <- "
library(lumberjack)
data(women)
start_log(women, logger=simple$new())
women$height <- women$height*2.54
women$weight <- women$weight*0.453592
dump_log()
"
write(script, file="myscript.R")
# run the script
lumberjack::run_file("myscript.R")
# read the logfile
read.csv("women_simple.csv")
}

}
\seealso{
Other control: \code{\link{\%>>\%}},
  \code{\link{dump_log}}, \code{\link{get_log}},
  \code{\link{start_log}}, \code{\link{stop_log}}
}
\concept{control}
