% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{m2_matrix}
\alias{m2_matrix}
\alias{m2_matrix.}
\alias{m2_numrows}
\alias{m2_numcols}
\alias{m2_length}
\alias{print.m2_matrix}
\alias{print.m2_image}
\alias{m2_kernel}
\alias{m2_kernel.}
\title{Create a new matrix in Macaulay2}
\usage{
m2_matrix(mat, ring, name, code = FALSE)

m2_matrix.(mat, ring, name, code = FALSE)

m2_numrows(x, code = FALSE, ...)

m2_numcols(x, code = FALSE, ...)

m2_length(x, code = FALSE, ...)

\method{print}{m2_matrix}(x, ...)

\method{print}{m2_image}(x, ...)

m2_kernel(mat, name, code = FALSE)

m2_kernel.(mat, name, code = FALSE)
}
\arguments{
\item{mat}{a matrix}

\item{ring}{a ring containing the matrix entries}

\item{name}{the \code{m2_name} of the object, which is it's name
on the M2 side}

\item{code}{return only the M2 code? (default: \code{FALSE})}

\item{x}{formal argument for print method}

\item{...}{...}
}
\value{
an object of class \code{m2_matrix}
}
\description{
Create a new matrix in Macaulay2
}
\examples{

\dontrun{ requires Macaulay2

##### basic usage
########################################

(mat <- m2_matrix(matrix(c(1,2,3,4,5,6), nrow = 3, ncol = 2)))
m2_matrix(matrix(c(1,2,3,4,5,6), nrow = 3, ncol = 2))

m2_name(mat)
m2(m2_name(mat))
m2(sprintf("class(\%s)", m2_name(mat)))
(mat <- m2_matrix.(matrix(c(1,2,3,4,5,6), nrow = 3, ncol = 2)))

##### known issues
########################################

ring("x", "y", "z", coefring = "QQ")
(mat <- matrix(mp(c("x","y","x+y","y-2","x-3","y-z")), nrow = 2, ncol = 3))
m2_matrix(mat, code = TRUE)
m2_matrix(mat)
# the above is an mpoly problem, not a m2r problem
# mpoly does not have a data structure for matrices (as of 12/2016)

mat_chars <- sapply(m2_matrix(mat), print, silent = TRUE)
dim(mat_chars) <- c(2, 3)
mat_chars


m2_numrows(mat)
m2_numcols(mat)
m2_parse(mat)

(mat <- m2_matrix(matrix(c(1,2),nrow=1)))
m2_kernel(mat)

}
}
