% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-min-id.R
\name{get_min_id}
\alias{get_min_id}
\title{Get Minimum Message ID in a Mailbox}
\usage{
get_min_id(imapconf, by = "MSN", flag, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{flag}{A string specifying the flag to be used for filtering messages.
Use \link{flag_options} to list the common flags used by IMAP
servers. Default is \code{NULL}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
A numeric \code{vector} of length \code{1} indicating the minimum id.
}
\description{
Get the smaller (minimum) message id in a Mailbox, considering
    messages with a specific flag.
}
\note{
\code{get_max_id} uses \code{ESEARCH} extension. Check if your server
    supports \code{ESEARCH} capability with \link{list_server_capabilities}.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

results <- imapconf \%>\%
    select_mailbox(mbox = "[Gmail]/Trash") \%>\%
    get_min_id(flag = "UNSEEN")

}

}
\seealso{
Other miscellaneous: \code{\link{add_flags}},
  \code{\link{copy_msg}}, \code{\link{count_msgs}},
  \code{\link{delete_msg}}, \code{\link{expunge}},
  \code{\link{get_max_id}}, \code{\link{move_msg}},
  \code{\link{remove_flags}}, \code{\link{replace_flags}}
}
\concept{miscellaneous}
