% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section-or-field-options.R
\name{section_or_field_options}
\alias{section_or_field_options}
\title{Section or Header Fields Options}
\usage{
section_or_field_options()
}
\value{
A \code{list} containing common header fields.
}
\description{
This function presents message sections and header fields
    that can be used for searching and fetching message contents. The header
    fields, particularly, are only a suggestion and indicate the most common
    terms. Some messages may not contain one or more of the listed fields.
    It is also possible that one or more fields not listed here may be used
    in some messages.
}
\note{
A message body is the (full) content of a message. It is simply lines
    of US-ASCII characters (Freed & Borenstein, 1996; Resnick, 2001). Therefore,
    if you want to do a search of a string in the whole message, including
    \code{HEADER} and \code{TEXT}, you can specify
    \code{section_or_field = "BODY"}.

While header is a part of the message body, indicating sender, date and
    other information, header fields are specific
    parts of the header of a message. "Header fields are lines
    composed of a field name, followed by a colon (":"), which is followed by
    a field body, and terminated by CRLF" (Resnick, 2001).

A message \code{TEXT} is the message itself, indicating the content
    written or produced by the sender.
}
\examples{
\dontrun{

library(mRpostman)
section_or_field_options()

}
}
\references{
Freed, N. and N. Borenstein, "Multipurpose Internet Mail
    Extensions (MIME) Part Two: Media Types", RFC 2046,
    \doi{10.17487/RFC2046}, November 1996,
    \url{https://www.rfc-editor.org/info/rfc2046}.

Resnick, P., Ed., "Internet Message Format", RFC 2822,
    \doi{10.17487/RFC2822}, April 2001,
    \url{https://www.rfc-editor.org/info/rfc2822}.

Crocker, D., "STANDARD FOR THE FORMAT OF ARPA INTERNET TEXT
    MESSAGES", STD 11, RFC 822, \doi{10.17487/RFC0822},
    August 1982, \url{https://www.rfc-editor.org/info/rfc822}.
}
\seealso{
Other options: \code{\link{flag_options}},
  \code{\link{metadata_options}}
}
\concept{options}
