% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routing_functions.R
\name{updateThetaForRouting}
\alias{updateThetaForRouting}
\title{Update the theta used for routing of an examinee object}
\usage{
updateThetaForRouting(examinee_object, current_module_position, combine_policy)
}
\arguments{
\item{examinee_object}{an \code{\linkS4class{examinee}} object.}

\item{current_module_position}{the current module position.}

\item{combine_policy}{\itemize{
  \item{} This is only applied when \code{module_position \%\% 2 == 0} (at Phase 2, which is the end of each test).
  \item{\code{conditional}} uses the combined theta (using items from the previous module combined with the current module), if the examinee was in the same grade in Phases 1 and 2. If the examinee was in different grades in Phases 1 and 2, then the theta estimate from Phase 2 is used.
  \item{\code{always}} uses the combined theta.
  \item{\code{never}} uses the theta estimate from Phase 2.
  \item{} (default = \code{conditional})
}}
}
\value{
an \code{\linkS4class{examinee}} object with its \code{estimated_theta_for_routing} slot updated.
}
\description{
\code{\link{updateThetaForRouting}} is a function for updating \code{\linkS4class{examinee}} objects after completing a module.
\code{\link{updateThetaForRouting}} determines what type of theta estimate is used to perform routing.
}
