% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.r
\docType{class}
\name{madness-class}
\alias{madness-class}
\alias{initialize,madness-method}
\alias{initialize,madness-class}
\alias{madness}
\title{Madness Class.}
\usage{
\S4method{initialize}{madness}(.Object, val, dvdx, xtag = NA_character_,
  vtag = NA_character_, varx = matrix(nrow = 0, ncol = 0))

madness(val, dvdx = NULL, vtag = NULL, xtag = NULL, varx = NULL)
}
\arguments{
\item{.Object}{a \code{madness} object, or proto-object.}

\item{val}{an \code{array} of some numeric value, of arbitrary
dimension.}

\item{dvdx}{a \code{matrix} of the derivative of 
(the vector of) \code{val} with respect to some independent 
variable, \eqn{X}{X}.}

\item{xtag}{an optional name for the \eqn{X} variable.}

\item{vtag}{an optional name for the \eqn{val} variable.}

\item{varx}{an optional variance-covariance matrix of
the independent variable, \eqn{X}{X}.}
}
\value{
An object of class \code{madness}.
}
\description{
An S4 class to enable forward differentiation of multivariate computations.
Think of \sQuote{madness} as \sQuote{multivariate automatic differentiation -ness.}
There is also a constructor method for \code{madness} objects, and a 
wrapper method.
}
\details{
A \code{madness} object contains a (multidimensional) 
value, and the derivative of that with respect to some independent
variable. The purpose is to simplify computation of multivariate 
derivatives, especially for use in the Delta method. Towards this
usage, one may store the covariance of the independent variable
in the object as well, from which the approximate variance-covariance
matrix can easily be computed. See \code{\link{vcov}}.

Note that derivatives are all implicitly 'flattened'. That is,
when we talk of the derivative of \eqn{i \times j}{i x j} 
matrix \eqn{Y}{Y} with respect to \eqn{m \times n}{m x n}
matrix \eqn{X}{X}, we mean the derivative of the \eqn{ij}{ij}
vector \eqn{\mathrm{vec}\left(Y\right)}{vec(Y)} with
respect to the \eqn{mn}{mn} vector
\eqn{\mathrm{vec}\left(X\right)}{vec(X)}. Moreover,
derivatives follow the 'numerator layout' convention: 
this derivative is a \eqn{ij \times mn}{ij x mn} matrix
whose first column is the derivative of 
\eqn{\mathrm{vec}\left(Y\right)}{vec(Y)} with respect
to \eqn{X_{1,1}}{X_11}. Numerator layout feels unnatural
because it makes a gradient vector of a scalar-valued function
into a row vector. Despite this deficiency, it makes 
the product rule feel more natural. (2FIX: is this so?)
}
\section{Slots}{

\describe{
\item{\code{val}}{an \code{array} of some numeric value. (Note that
\code{array} includes \code{matrix} as a subclass.) The numeric
value can have arbitrary dimension.}

\item{\code{dvdx}}{a \code{matrix} of the derivative of 
(the vector of) \code{val} with respect to some independent 
variable, \eqn{X}{X}. 
A Derivative is indeed a 2-dimensional matrix.
Derivatives have all been 'flattened'. See the details. 
If not given, defaults
to the identity matrix, in which case \eqn{val=X}{val = X},
which is useful to initialization. Note that the derivative
is with respect to an 'unrestricted' \eqn{X}.}

\item{\code{xtag}}{an optional name for the \eqn{X} variable. 
Operations between two objects of the class with distinct
\code{xtag} data will result in an error, since they are 
considered to have different independent variables.}

\item{\code{vtag}}{an optional name for the \eqn{val} variable. 
This will be propagated forward.}

\item{\code{varx}}{an optional variance-covariance matrix of
the independent variable, \eqn{X}{X}.}
}}

\examples{
obj <- new("madness", val=matrix(rnorm(10*10),nrow=10), dvdx=diag(100), xtag="foo", vtag="foo")
obj2 <- madness(val=matrix(rnorm(10*10),nrow=10), xtag="foo", vtag="foo^2")

}
\references{
Petersen, Kaare Brandt and Pedersen, Michael Syskind. "The Matrix Cookbook."
Technical University of Denmark (2012). 
\url{http://www2.imm.dtu.dk/pubdb/p.php?3274}

Magnus, Jan R. and Neudecker, H. "Matrix Differential Calculus with Applications in Statistics and Econometrics."
3rd Edition. Wiley Series in Probability and Statistics: Texts and References Section (2007).
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{differentiation}
\keyword{multivariate}
