% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madlapply.R
\name{madlapply}
\alias{madlapply}
\title{madlapply}
\usage{
madlapply(X = NULL, FUN = NULL, exports = NULL, evals = NULL, ...)
}
\arguments{
\item{X}{a vector (atomic or list) or an \code{\link{expression}} object. Other objects
(including classed objects) will be coerced by base::\code{\link{as.list}}}

\item{FUN}{the function to be applied to each element of X}

\item{exports}{A list containing a list for each environment which contains imports. Each list contains a character vector and a character or an expression.
The first listing all Objects and Functions to be Exported. The second lists the associated environment. The environment in which the expression is evaluated is
the environment of FUN.}

\item{evals}{List of expressions to evaluate. See details for more information}

\item{...}{additional arguments to pass to FUN: beware of partial matching to earlier arguments.}
}
\value{
A list with one entry for each element in X
}
\description{
{ Wrapper Function that executes multiple function calls on one core using 
lapply or on the supplied number of cores using parLapply if the parallel option is set to TRUE.
Make sure the package \code{\link[parallel]{parallel}} is installed and runs on your machine before 
setting parallel to TRUE.
}
}
\details{
{
If your are using madlapply insice a calcFunction you don't have to export or evaluate any objects and functions or packages. 
}
}
\examples{

library(madrat)
library(magclass)

input <- #input
array(2, c(10,5,1))
powwrap <- function(#input=array(2, c(10,5,1))
){
# create a variable which has to be exported to the workers
pow <- function(exponent){
 # as magclass is not part of base, therefore the library
 #(magclass has to be evaluated on all the workers)
 return(as.magpie(
 input^exponent))
 }
 
 #actuall madlapply call 
 resultnopar <- madlapply(X=c(2:10), FUN=pow, #stating X and FUN
               exports=list(list(c("input"),expression(environment()))),
                # listing the objects or function 
                #to be exported and their origin environments
              evals=c("magclass" )) # libraries to be evaluated 
                                               
                                               
                return(resultnopar)
 }
 
 
 res <- powwrap()



}
\author{
Stephen Wirth, Jan Philipp Dietrich
}
