% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaestroPipelineList.R
\name{MaestroPipelineList}
\alias{MaestroPipelineList}
\title{Class for a list of MaestroPipelines
A MaestroPipelineList is created when there are multiple maestro pipelines in a
single script}
\description{
Class for a list of MaestroPipelines
A MaestroPipelineList is created when there are multiple maestro pipelines in a
single script

Class for a list of MaestroPipelines
A MaestroPipelineList is created when there are multiple maestro pipelines in a
single script
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{MaestroPipelines}}{list of pipelines}

\item{\code{n_pipelines}}{number of pipelines in the list}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MaestroPipelineList-new}{\code{MaestroPipelineList$new()}}
\item \href{#method-MaestroPipelineList-print}{\code{MaestroPipelineList$print()}}
\item \href{#method-MaestroPipelineList-add_pipelines}{\code{MaestroPipelineList$add_pipelines()}}
\item \href{#method-MaestroPipelineList-get_pipe_names}{\code{MaestroPipelineList$get_pipe_names()}}
\item \href{#method-MaestroPipelineList-get_pipe_by_name}{\code{MaestroPipelineList$get_pipe_by_name()}}
\item \href{#method-MaestroPipelineList-get_schedule}{\code{MaestroPipelineList$get_schedule()}}
\item \href{#method-MaestroPipelineList-get_timely_pipelines}{\code{MaestroPipelineList$get_timely_pipelines()}}
\item \href{#method-MaestroPipelineList-get_primary_pipes}{\code{MaestroPipelineList$get_primary_pipes()}}
\item \href{#method-MaestroPipelineList-check_timeliness}{\code{MaestroPipelineList$check_timeliness()}}
\item \href{#method-MaestroPipelineList-get_status}{\code{MaestroPipelineList$get_status()}}
\item \href{#method-MaestroPipelineList-get_errors}{\code{MaestroPipelineList$get_errors()}}
\item \href{#method-MaestroPipelineList-get_warnings}{\code{MaestroPipelineList$get_warnings()}}
\item \href{#method-MaestroPipelineList-get_messages}{\code{MaestroPipelineList$get_messages()}}
\item \href{#method-MaestroPipelineList-get_artifacts}{\code{MaestroPipelineList$get_artifacts()}}
\item \href{#method-MaestroPipelineList-get_network}{\code{MaestroPipelineList$get_network()}}
\item \href{#method-MaestroPipelineList-validate_network}{\code{MaestroPipelineList$validate_network()}}
\item \href{#method-MaestroPipelineList-run}{\code{MaestroPipelineList$run()}}
\item \href{#method-MaestroPipelineList-clone}{\code{MaestroPipelineList$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-new"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-new}{}}}
\subsection{Method \code{new()}}{
Create a MaestroPipelineList object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$new(MaestroPipelines = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{MaestroPipelines}}{list of MaestroPipelines}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
MaestroPipelineList
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-print"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-print}{}}}
\subsection{Method \code{print()}}{
Print the MaestroPipelineList
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
print
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-add_pipelines"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-add_pipelines}{}}}
\subsection{Method \code{add_pipelines()}}{
Add pipelines to the list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$add_pipelines(MaestroPipelines = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{MaestroPipelines}}{list of MaestroPipelines}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_pipe_names"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_pipe_names}{}}}
\subsection{Method \code{get_pipe_names()}}{
Get names of the pipelines in the list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_pipe_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_pipe_by_name"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_pipe_by_name}{}}}
\subsection{Method \code{get_pipe_by_name()}}{
Get a MaestroPipeline by its name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_pipe_by_name(pipe_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pipe_name}}{name of the pipeline}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
MaestroPipeline
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_schedule"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_schedule}{}}}
\subsection{Method \code{get_schedule()}}{
Get the schedule as a data.frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_schedule()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_timely_pipelines"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_timely_pipelines}{}}}
\subsection{Method \code{get_timely_pipelines()}}{
Get a new MaestroPipelineList containing only those pipelines scheduled to run
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_timely_pipelines(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments passed to self$check_timeliness}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
MaestroPipelineList
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_primary_pipes"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_primary_pipes}{}}}
\subsection{Method \code{get_primary_pipes()}}{
Get pipelines that are primary (i.e., don't have an inputting pipeline)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_primary_pipes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list of MaestroPipelines
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-check_timeliness"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-check_timeliness}{}}}
\subsection{Method \code{check_timeliness()}}{
Check whether pipelines in the list are scheduled to run based on orchestrator frequency and current time
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$check_timeliness(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments passed to self$check_timeliness}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_status"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_status}{}}}
\subsection{Method \code{get_status()}}{
Get status of the pipelines as a data.frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_status()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_errors"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_errors}{}}}
\subsection{Method \code{get_errors()}}{
Get list of errors from the pipelines
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_errors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_warnings"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_warnings}{}}}
\subsection{Method \code{get_warnings()}}{
Get list of warnings from the pipelines
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_warnings()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_messages"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_messages}{}}}
\subsection{Method \code{get_messages()}}{
Get list of messages from the pipelines
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_messages()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_artifacts"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_artifacts}{}}}
\subsection{Method \code{get_artifacts()}}{
Get artifacts (return values) from the pipelines
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_artifacts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-get_network"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-get_network}{}}}
\subsection{Method \code{get_network()}}{
Get the network structure as a edge list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$get_network()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-validate_network"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-validate_network}{}}}
\subsection{Method \code{validate_network()}}{
Validates whether all inputs and outputs exist and that the network is a valid DAG
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$validate_network()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
warning or invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-run"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-run}{}}}
\subsection{Method \code{run()}}{
Runs all the pipelines in the list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$run(..., cores = 1L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments passed to MaestroPipeline$run}

\item{\code{cores}}{if using multicore number of cores to run in (uses \code{furrr})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipelineList-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipelineList-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipelineList$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
