% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_status.R
\name{get_status}
\alias{get_status}
\title{Get the statuses of the pipelines in a MaestroSchedule object}
\usage{
get_status(schedule)
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}
}
\value{
data.frame
}
\description{
A status data.frame contains the names and locations of the pipelines as
well as information around whether they were invoked, the status (error, warning, etc.),
and the run time.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  schedule <- run_schedule(
    schedule,
    orch_frequency = "1 day",
    quiet = TRUE
  )

  get_status(schedule)

  # Alternatively, use the underlying R6 method
  schedule$get_status()
}
}
