% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magpie_expand.R
\name{magpie_expand}
\alias{magpie_expand}
\title{magpie_expand}
\usage{
magpie_expand(x, ref)
}
\arguments{
\item{x}{MAgPIE object that should be expanded}

\item{ref}{MAgPIE object that serves as a reference}
}
\value{
An expanded version of x.
}
\description{
Expands a MAgPIE object based on a reference
}
\details{
Expansion means here that the dimensions of x are expanded acordingly to
ref. Please note that this is really only about expansion. In the case that
one dimension of ref is smaller than of x nothing happens with this
dimension. At the moment magpie_expand is only internally available in the
magclass library

You can influence the verbosity of this function by setting the option
"magclass.verbosity". By default verbosity is set to 2 which means that
warnings as well as notes are returned. Setting verbosity to 1 means that
only warnings are returned but no notes. This is done by
options(verbosity.level=1)

With version 5 of the package magpie_expand has been updated to a newer version
(currently 2.1). To switch to the old setup you have to set 
\code{options(magclass_expand_version=1)}.

By default expansion is based on the elements in a dimension ignoring the set name of 
the dimension. To expand based on set names instead of contents (recommended) you can 
switch \code{options(magclass_setMatching=TRUE)}. Please be careful with this setting 
as it alters the behavior of magclass objects quite significantly! For more information
have a look at \code{vignette("magclass-expansion")}.
}
\examples{

 a <- new.magpie(c("AFR","CPA"),"y1995",c("m","n"))
 b <- new.magpie("GLO","y1995",c("bla","blub"))
 magpie_expand(b,a)
 options(magclass.verbosity=1)
 magpie_expand(b,a)

}
\seealso{
\code{\link{as.magpie}}, \code{\link[base]{options}}
}
\author{
Jan Philipp Dietrich
}
