% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncells.R, R/ndata.R, R/nregions.R, R/nyears.R
\name{ncells}
\alias{ncells}
\alias{nyears}
\alias{ndata}
\alias{nregions}
\title{Count elements}
\usage{
ncells(x)

ndata(x, fulldim = FALSE)

nregions(x)

nyears(x)
}
\arguments{
\item{x}{A MAgPIE-object}

\item{fulldim}{specifies, how the object is treated. In case of FALSE, it is
assumed that x is 3 dimensional and dimnames(x)[[3]] is returned. In case of
TRUE, the dimnames of the real third dimension namesare returned}
}
\value{
\item{value}{The number of cells/years/datasets/regions of \code{x}}
}
\description{
Functions to count the number of cells/years/datasets/regions of an
MAgPIE-object
}
\section{Functions}{
\itemize{
\item \code{ndata}: count datasets

\item \code{nregions}: count regions

\item \code{nyears}: count years
}}

\examples{

  a <- is.magpie(NULL)
  ncells(a)
  nyears(a)
  ndata(a)
  nregions(a)

}
\author{
Jan Philipp Dietrich
}
