% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_non_finite.R
\name{replace_non_finite}
\alias{replace_non_finite}
\title{Replace Non-Finite Data}
\usage{
replace_non_finite(x, replace = 0)
}
\arguments{
\item{x}{A vector or \code{\link[=magclass]{magpie}} object.}

\item{replace}{A value to replace non-finite data with.}
}
\value{
A vector or \code{\link[=magclass]{magpie}} object, same as \code{x}.
}
\description{
Replaces all instances of non-finite data (\code{NA}, \code{NaN}, \code{Inf}, and \code{-Inf}).
}
\examples{
part  <- new.magpie(letters[1:3], years = 'y1995', names = 'foo')
total <- new.magpie(letters[1:3], years = 'y1995', names = 'foo')

part[,,]  <- c(0, 1, 2)
total[,,] <- c(0, 10, 10)

part / total

replace_non_finite(part / total)

}
\author{
Michaja Pehl
}
