% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit.R
\name{editing}
\alias{editing}
\alias{image_read}
\alias{image_write}
\alias{image_convert}
\alias{image_display}
\alias{image_browse}
\alias{image_join}
\title{Image Editing}
\usage{
image_read(path, density = NULL, depth = NULL)

image_write(image, path = NULL, format = NULL, quality = NULL,
  depth = NULL, density = NULL, comment = NULL, flatten = FALSE)

image_convert(image, format = NULL, type = NULL, colorspace = NULL,
  depth = NULL, antialias = NULL)

image_display(image, animate = TRUE)

image_browse(image, browser = getOption("browser"))

image_join(...)
}
\arguments{
\item{path}{a file, url, or raster object or bitmap array}

\item{density}{resolution to render pdf or svg}

\item{depth}{color depth (either 8 or 16)}

\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{format}{output format such as \code{"png"}, \code{"jpeg"}, \code{"gif"}, \code{"rgb"} or \code{"rgba"}.}

\item{quality}{number between 0 and 100 for jpeg quality. Defaults to 75.}

\item{comment}{text string added to the image metadata for supported formats}

\item{flatten}{should image be flattened before writing? This also replaces
transparency with background color.}

\item{type}{a magick \href{https://www.imagemagick.org/Magick++/Enumerations.html#ImageType}{ImageType}
classification for example \code{grayscale} to convert image to black/white}

\item{colorspace}{string with a magick \href{https://www.imagemagick.org/Magick++/Enumerations.html#ColorspaceType}{ColorspaceType}
for example \code{"gray"}, \code{"rgb"} or \code{"cmyk"}}

\item{antialias}{enable anti-aliasing for text and strokes}

\item{animate}{support animations in the X11 display}

\item{browser}{argument passed to \link[utils:browseURL]{browseURL}}

\item{...}{several images or lists of images to be combined}
}
\description{
Read, write and join or combine images.
All image functions are vectorized, meaning they operate either on a single frame
or a series of frames (e.g. a collage, video, or animation).
Besides paths and URLs, the \code{\link[=image_read]{image_read()}} function supports all commonly used bitmap
and raster types.
}
\details{
Besides functions
above, all standard base vector methods such as \link{[}, \link{[[}, \code{\link[=c]{c()}}, \code{\link[=as.list]{as.list()}},
\code{\link[=as.raster]{as.raster()}}, \code{\link[=rev]{rev()}}, \code{\link[=length]{length()}}, and \code{\link[=print]{print()}}  can be used with magick images.

Use the standard \code{img[i]} syntax to extract a subset of the frames from an image.
The \code{img[[i]]} method is used to extract a single frame as a bitmap object, i.e.
a raw matrix with pixel values.

X11 is required for \code{image_display()} which is only works on some platforms. A more
portable method is \code{image_browse()} which opens the image in a browser. RStudio has
an embedded viewer that does this automatically which is quite nice.
}
\examples{
# Download image from the web
frink <- image_read("https://jeroen.github.io/images/frink.png")
worldcup_frink <- image_fill(frink, "orange", "+100+200", 30000)
image_write(worldcup_frink, "output.png")

# extract raw bitmap array
bitmap <- frink[[1]]

# replace pixels with #FF69B4 ('hot pink') and convert back to image
bitmap[,50:100, 50:100] <- as.raw(c(0xff, 0x69, 0xb4, 0xff))
image_read(bitmap)

# Plot to graphics device via legacy raster format
raster <- as.raster(frink)
par(ask=FALSE)
plot(raster)

# Read bitmap arrays
curl::curl_download("https://www.r-project.org/logo/Rlogo.png", "Rlogo.png")
image_read(png::readPNG("Rlogo.png"))

curl::curl_download("https://jeroen.github.io/images/example.webp", "example.webp")
image_read(webp::read_webp("example.webp"))

curl::curl_download("http://jeroen.github.io/images/tiger.svg", "tiger.svg")
image_read(rsvg::rsvg("tiger.svg"))
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{effects}},
  \code{\link{ocr}}, \code{\link{painting}},
  \code{\link{transform}}
}
