% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{thresholding}
\alias{thresholding}
\alias{image_threshold}
\alias{image_level}
\alias{image_lat}
\title{Image thresholding}
\usage{
image_threshold(
  image,
  type = c("black", "white"),
  threshold = "50\%",
  channel = NULL
)

image_level(
  image,
  black_point = 0,
  white_point = 100,
  mid_point = 1,
  channel = NULL
)

image_lat(image, geometry = "10x10+5\%")
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{type}{type of thresholding, either one of lat, black or white (see details below)}

\item{threshold}{pixel intensity threshold percentage for black or white thresholding}

\item{channel}{a value of \code{\link[=channel_types]{channel_types()}} specifying which channel(s) to set}

\item{black_point}{value between 0 and 100, the darkest color in the image}

\item{white_point}{value between 0 and 100, the lightest color in the image}

\item{mid_point}{value between 0 and 10 used for gamma correction}

\item{geometry}{pixel window plus offset for LAT algorithm}
}
\description{
Thresholding an image can be used for simple and straightforward image segmentation.
The function \code{\link[=image_threshold]{image_threshold()}} allows to do black and white thresholding whereas
\code{\link[=image_lat]{image_lat()}} performs local adaptive thresholding.
}
\details{
\itemize{
\item \code{image_threshold(type = "black")}: Forces all pixels below the threshold into black while leaving all pixels
at or above the threshold unchanged
\item \code{image_threshold(type = "white")}: Forces all pixels above the threshold into white while leaving all pixels
at or below the threshold unchanged
\item \code{image_lat()}: Local Adaptive Thresholding. Looks in a box (width x height) around the
pixel neighborhood if the pixel value is bigger than the average minus an offset.
}
}
\examples{
test <- image_convert(logo, colorspace = "Gray")
image_threshold(test, type = "black", threshold = "50\%")
image_threshold(test, type = "white", threshold = "50\%")

# Turn image into BW
test \%>\%
  image_threshold(type = "white", threshold = "50\%") \%>\%
  image_threshold(type = "black", threshold = "50\%")

# adaptive thresholding
image_lat(test, geometry = '10x10+5\%')
}
