% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_posterior_diagnostics.R
\name{eval_pc_prior}
\alias{eval_pc_prior}
\title{Evaluate PC prior for variance proportion}
\usage{
eval_pc_prior(x, obj, param, logitscale = FALSE)
}
\arguments{
\item{x}{Values to evaluate prior in.}

\item{obj}{Prior object from \link[makemyprior]{make_prior}}

\item{param}{Which weight to plot, indicated using syntax shown when printing (do not need to include the
\code{w[..]} part to indicate that it is a variance proportion, but can be included). Print the prior object
to see syntax for each weight.}

\item{logitscale}{Is the input \code{x} on logit-scale? (default \code{FALSE}).}
}
\value{
Returns density for the given variance proportion.
}
\description{
Evaluate PC prior for a variance proportion.
}
\examples{
ex_prior <- makemyprior_example_model()
eval_pc_prior(seq(0, 1, 0.01), ex_prior, "eps/eps_a_b")
# or:
eval_pc_prior(seq(0, 1, 0.01), ex_prior, "w[eps/eps_a_b]")

}
