% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_with_source}
\alias{make_with_source}
\title{Make targets out of dependencies using a source file}
\usage{
make_with_source(
  source,
  targets,
  dependencies,
  packages = NULL,
  envir = new.env(parent = parent.frame()),
  quiet = getOption("makepipe.quiet"),
  ...
)
}
\arguments{
\item{source}{The path to an R script which makes the \code{targets}}

\item{targets}{A character vector of paths to files}

\item{dependencies}{A character vector of paths to files which the \code{targets}
depend on}

\item{packages}{A character vector of names of packages which \code{targets}
depend on}

\item{envir}{The environment in which to execute the \code{source} or \code{recipe}. By
default, execution will take place in a fresh environment whose parent is
the calling environment.}

\item{quiet}{A logical determining whether or not messages are signaled}

\item{...}{Additional parameters to pass to \code{base::source()}}
}
\value{
\code{NULL} invisibly.
}
\description{
Make targets out of dependencies using a source file
}
\examples{
\dontrun{
# Merge files in fresh environment if raw data has been updated since last
# merged
make_with_source(
  source = "merge_data.R",
  targets = "data/merged_data.Rds",
  dependencies = c("data/raw_data.Rds", "data/raw_pop.Rds")
)


# Merge files in current environment if raw data has been updated since last
# merged. (If source executed, all objects bound in source will be available
# in current env).
make_with_source(
  source = "merge_data.R",
  targets = "data/merged_data.Rds",
  dependencies = c("data/raw_data.Rds", "data/raw_pop.Rds"),
  envir = environment()
)


# Merge files in global environment if raw data has been updated since last
# merged. (If source executed, all objects bound in source will be available
# in global env).
make_with_source(
  source = "merge_data.R",
  targets = "data/merged_data.Rds",
  dependencies = c("data/raw_data.Rds", "data/raw_pop.Rds"),
  envir = globalenv()
)
}

}
\seealso{
Other make: 
\code{\link{make_with_recipe}()}
}
\concept{make}
