% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_reference_spectra.R
\name{set_reference_spectra}
\alias{set_reference_spectra}
\title{Set a reference spectrum for each cluster}
\usage{
set_reference_spectra(cluster_df, metadata_df)
}
\arguments{
\item{cluster_df}{A tibble of \emph{n} rows for each spectra produced by \link{delineate_with_similarity} function with at least the following columns:
\itemize{
\item \code{name}: the rownames of the similarity matrix indicating the spectra names
\item \code{membership}: integers stating the cluster number to which the spectra belong to. It starts from 1 to \emph{c}, the total number of clusters.
\item \code{cluster_size}: integers indicating the total number of spectra in the corresponding cluster.
}}

\item{metadata_df}{A tibble of \emph{n} rows for each spectra produced by the \link{process_spectra} function with median signal-to-noise ratio (\code{SNR}), peaks number (\code{peaks}), and spectra names in the \code{name} column.}
}
\value{
A merged tibble in the same order as \code{cluster_df} with both the columns of \code{cluster_df} and \code{metadata_df}, as well as a logical column \code{is_reference} indicating if the spectrum is the reference spectra of the cluster.
}
\description{
Define a high-quality spectra as a representative
spectra of the cluster based on the highest median signal-to-noise ratio
and the number of detected peaks
}
\examples{
# Get an example directory of six Bruker MALDI Biotyper spectra
# Import the six spectra and
# Transform the spectra signals according to Strejcek et al. (2018)
processed <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
) \%>\%
  import_biotyper_spectra() \%>\%
  process_spectra()

# Toy similarity matrix between the six example spectra of
#  three species. The cosine metric is used and a value of
#  zero indicates dissimilar spectra and a value of one
#  indicates identical spectra.
cosine_similarity <- matrix(
  c(
    1, 0.79, 0.77, 0.99, 0.98, 0.98,
    0.79, 1, 0.98, 0.79, 0.8, 0.8,
    0.77, 0.98, 1, 0.77, 0.77, 0.77,
    0.99, 0.79, 0.77, 1, 1, 0.99,
    0.98, 0.8, 0.77, 1, 1, 1,
    0.98, 0.8, 0.77, 0.99, 1, 1
  ),
  nrow = 6,
  dimnames = list(
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    ),
    c(
      "species1_G2", "species2_E11", "species2_E12",
      "species3_F7", "species3_F8", "species3_F9"
    )
  )
)
# Delineate clusters based on a 0.92 threshold applied
#  to the similarity matrix
clusters <- delineate_with_similarity(
  cosine_similarity,
  threshold = 0.92
)

# Set reference spectra with the toy example
set_reference_spectra(clusters, processed$metadata)
}
\seealso{
\link{delineate_with_similarity}, \link{pick_spectra}
}
