/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Boostable;
import cc.mallet.classify.C45;
import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Maths;
import java.util.logging.Logger;

public class C45Trainer
extends ClassifierTrainer<C45>
implements Boostable {
    private static Logger logger = MalletLogger.getLogger(C45Trainer.class.getName());
    boolean m_depthLimited = false;
    int m_maxDepth = 4;
    int m_minNumInsts = 2;
    boolean m_doPruning = true;
    C45 classifier;

    @Override
    public C45 getClassifier() {
        return this.classifier;
    }

    public C45Trainer() {
    }

    public C45Trainer(int maxDepth) {
        this.m_maxDepth = maxDepth;
        this.m_depthLimited = true;
    }

    public C45Trainer(boolean doPruning) {
        this.m_doPruning = doPruning;
    }

    public C45Trainer(int maxDepth, boolean doPruning) {
        this.m_depthLimited = true;
        this.m_maxDepth = maxDepth;
        this.m_doPruning = doPruning;
    }

    public void setDoPruning(boolean doPruning) {
        this.m_doPruning = doPruning;
    }

    public boolean getDoPruning() {
        return this.m_doPruning;
    }

    public void setDepthLimited(boolean depthLimited) {
        this.m_depthLimited = depthLimited;
    }

    public boolean getDepthLimited() {
        return this.m_depthLimited;
    }

    public void setMaxDepth(int maxDepth) {
        this.m_maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this.m_maxDepth;
    }

    public void setMinNumInsts(int minNumInsts) {
        this.m_minNumInsts = minNumInsts;
    }

    public int getMinNumInsts() {
        return this.m_minNumInsts;
    }

    protected void splitTree(C45.Node node, int depth) {
        if (this.m_depthLimited && depth == this.m_maxDepth) {
            logger.info("Splitting stopped: maximum depth reached (" + this.m_maxDepth + ")");
            return;
        }
        if (Maths.almostEquals(node.getGainRatio().getBaseEntropy(), 0.0)) {
            logger.info("Splitting stopped: entropy of node too small (" + node.getGainRatio().getBaseEntropy() + ")");
            return;
        }
        if (Maths.almostEquals(node.getGainRatio().getMaxValue(), 0.0)) {
            logger.info("Splitting stopped: node has insignificant gain ratio (" + node.getGainRatio().getMaxValue() + ")");
            return;
        }
        logger.info("Splitting feature \"" + node.getSplitFeature() + "\" at threshold=" + node.getGainRatio().getMaxValuedThreshold() + " gain ratio=" + node.getGainRatio().getMaxValue());
        node.split();
        this.splitTree(node.getLeftChild(), depth + 1);
        this.splitTree(node.getRightChild(), depth + 1);
    }

    @Override
    public C45 train(InstanceList trainingList) {
        FeatureSelection selectedFeatures = trainingList.getFeatureSelection();
        if (selectedFeatures != null) {
            throw new UnsupportedOperationException("FeatureSelection not yet implemented.");
        }
        C45.Node root = new C45.Node(trainingList, null, this.m_minNumInsts);
        this.splitTree(root, 0);
        C45 tree = new C45(trainingList.getPipe(), root);
        logger.info("C45 learned: (size=" + tree.getSize() + ")\n");
        tree.print();
        if (this.m_doPruning) {
            tree.prune();
            logger.info("\nPruned C45: (size=" + tree.getSize() + ")\n");
            root.print();
        }
        root.stopGrowth();
        this.classifier = tree;
        return this.classifier;
    }
}

