/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.MultiSegmentationEvaluator;
import cc.mallet.fst.Segment;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.ConstrainedForwardBackwardConfidenceEstimator;
import cc.mallet.fst.confidence.TransducerConfidenceEstimator;
import cc.mallet.fst.confidence.TransducerCorrector;
import cc.mallet.types.ArraySequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.logging.Logger;

public class IsolatedSegmentTransducerCorrector
implements TransducerCorrector {
    private static Logger logger = MalletLogger.getLogger(IsolatedSegmentTransducerCorrector.class.getName());
    TransducerConfidenceEstimator confidenceEstimator;
    Transducer model;

    public IsolatedSegmentTransducerCorrector(TransducerConfidenceEstimator confidenceEstimator, Transducer model) {
        this.confidenceEstimator = confidenceEstimator;
        this.model = model;
    }

    public IsolatedSegmentTransducerCorrector(Transducer model) {
        this(new ConstrainedForwardBackwardConfidenceEstimator(model), model);
    }

    @Override
    public ArrayList correctLeastConfidentSegments(InstanceList ilist, Object[] startTags, Object[] continueTags) {
        ArrayList<ArraySequence<String>> correctedPredictionList = new ArrayList<ArraySequence<String>>();
        for (int i = 0; i < ilist.size(); ++i) {
            int j;
            logger.fine("correcting instance# " + i + " / " + ilist.size());
            Instance instance = (Instance)ilist.get(i);
            Segment[] orderedSegments = new Segment[1];
            orderedSegments = this.confidenceEstimator.rankSegmentsByConfidence(instance, startTags, continueTags);
            Segment leastConfidentSegment = orderedSegments[0];
            logger.fine("Ordered Segments:\nTrue sequence: " + leastConfidentSegment.getTruth());
            for (int j2 = 0; j2 < orderedSegments.length; ++j2) {
                logger.fine(orderedSegments[j2].toString());
            }
            MultiSegmentationEvaluator eval = new MultiSegmentationEvaluator(new InstanceList[0], new String[0], startTags, continueTags);
            Sequence truth = leastConfidentSegment.getTruth();
            Sequence predicted = leastConfidentSegment.getPredicted();
            int numIncorrect = eval.numIncorrectSegments(truth, predicted);
            String[] sequence = new String[truth.size()];
            for (int j3 = 0; j3 < truth.size(); ++j3) {
                sequence[j3] = j3 <= leastConfidentSegment.getEnd() && j3 >= leastConfidentSegment.getStart() ? (String)truth.get(j3) : (String)predicted.get(j3);
            }
            ArraySequence<String> segmentCorrectedOutput = new ArraySequence<String>(sequence);
            logger.fine("Original prediction: ");
            for (j = 0; j < predicted.size(); ++j) {
                logger.fine((String)predicted.get(j) + "\t");
            }
            logger.fine("\nCorrected prediction: ");
            for (j = 0; j < segmentCorrectedOutput.size(); ++j) {
                logger.fine(segmentCorrectedOutput.get(j) + "\t");
            }
            logger.fine("");
            if (numIncorrect > -1) {
                correctedPredictionList.add(segmentCorrectedOutput);
                continue;
            }
            correctedPredictionList.add(null);
        }
        return correctedPredictionList;
    }
}

