/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.Variable;

public class BoltzmannUnaryFactor
extends TableFactor {
    private double theta;
    private Variable var;

    public BoltzmannUnaryFactor(Variable var, double theta) {
        super(var, BoltzmannUnaryFactor.theta2values(theta));
        this.theta = theta;
        this.var = var;
        if (var.getNumOutcomes() != 2) {
            throw new IllegalArgumentException("Discrete variable " + var + " in BoltzmannUnary must be binary.");
        }
    }

    private static double[] theta2values(double theta) {
        return new double[]{1.0, Math.exp(theta)};
    }

    @Override
    public Factor duplicate() {
        return new BoltzmannUnaryFactor(this.var, this.theta);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return this.equals(p);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.theta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltzmannUnaryFactor that = (BoltzmannUnaryFactor)o;
        if (this.theta != that.theta) {
            return false;
        }
        return !(this.var != null ? !this.var.equals(that.var) : that.var != null);
    }

    public int hashCode() {
        int result = new Double(this.theta).hashCode();
        result = 29 * result + (this.var != null ? this.var.hashCode() : 0);
        return result;
    }

    @Override
    public String prettyOutputString() {
        return this.var.getLabel() + " ~ Unary " + Double.toString(this.theta);
    }

    @Override
    public Factor multiply(Factor other) {
        TableFactor result = new TableFactor(this);
        result.multiplyBy(other);
        return result;
    }
}

