/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.DictionaryElementType;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;

public class IndexWord
implements DictionaryElement {
    static final long serialVersionUID = -2136983562978852712L;
    private POS _pos;
    private String _lemma;
    private long[] _synsetOffsets;
    private transient Synset[] _synsets;
    private transient boolean _synsetsLoaded = false;
    private transient String _cachedToString = null;

    public IndexWord(String lemma, POS pos, long[] synsetOffsets) {
        this._lemma = lemma;
        this._pos = pos;
        this._synsetOffsets = synsetOffsets;
        this._synsets = new Synset[synsetOffsets.length];
    }

    public DictionaryElementType getType() {
        return DictionaryElementType.INDEX_WORD;
    }

    public boolean equals(Object object) {
        return object instanceof IndexWord && ((IndexWord)object).getLemma().equals(this.getLemma()) && ((IndexWord)object).getPOS().equals(this.getPOS());
    }

    public int hashCode() {
        return this.getLemma().hashCode() ^ this.getPOS().hashCode();
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_002", new Object[]{this.getLemma(), this.getPOS()});
        }
        return this._cachedToString;
    }

    public POS getPOS() {
        return this._pos;
    }

    public String getLemma() {
        return this._lemma;
    }

    public long[] getSynsetOffsets() {
        return this._synsetOffsets;
    }

    public Object getKey() {
        return this.getLemma();
    }

    public int getSenseCount() {
        return this._synsetOffsets.length;
    }

    public Synset[] getSenses() throws JWNLException {
        if (!this._synsetsLoaded) {
            for (int i = 0; i < this.getSynsetOffsets().length; ++i) {
                this.loadSynset(i);
            }
            this._synsetsLoaded = true;
        }
        return this._synsets;
    }

    public Synset getSense(int index) throws JWNLException {
        this.loadSynset(index - 1);
        return this._synsets[index - 1];
    }

    private void loadSynset(int i) throws JWNLException {
        if (this._synsets[i] == null) {
            this._synsets[i] = Dictionary.getInstance().getSynsetAt(this._pos, this._synsetOffsets[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._pos = POS.getPOSForKey(this._pos.getKey());
        this._synsets = new Synset[this._synsetOffsets.length];
    }
}

