% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{y_iris}
\alias{y_iris}
\title{Iris class data for Species classification}
\format{
A list of two named matrices, 'train' and 'test', respresenting the training and test sets for the predictors. These have 3 indicator 
columns each, with 120 and 30 rows respectively.
   \describe{
      \item{\code{Species.setosa}}{Indicator column for the species class setosa}
      \item{\code{Species.versicolor}}{Indicator column for the species class versicolor}
      \item{\code{Species.virginica}}{Indicator column for the species class virginica}
 }
}
\source{
Fisher, R. A. (1936) The use of multiple measurements in taxonomic problems. Annals of Eugenics, 7, Part II, 179-188. 
 The data were collected by Anderson, Edgar (1935). The irises of the Gaspe Peninsula, Bulletin of the American Iris Society, 59, 2-5
 \itemize{\item{\url{https://stat.ethz.ch/R-manual/R-devel/library/datasets/html/iris.html}}}
}
\usage{
y_iris
}
\description{
This data was taken from Edgar Anderson's famous iris data set. This gives the measurements (in centimeters)
of the variables sepal length and width and petal length and width, respectively, for 50 flowers from each of 3 species of iris. 
The species are Iris setosa, versicolor, and virginica. This is the target dataset (as a counterpart to the \code{x_iris} dataset) 
and thus only retains the Species information. As with the \code{x_iris} dataset, the data has been split into a training and test
set with a ratio of 4:1. Following this the species class has been one-hot encoded to give three columns, one for each species level.
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language. Wadsworth & Brooks/Cole.
}
\keyword{datasets}
