% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan.heatmap.v1.R
\name{manhplusplot}
\alias{manhplusplot}
\title{Generate the manhattan++ plot}
\usage{
manhplusplot(infile, outfile, configfile, snpfile, drawastiff = F,
  GWS = 5e-08, FDR = 0.001, MAF = 0.05, chrname = "chr",
  posname = "pos", pvalname = "pvalue", frqname = "maf",
  conseqname = "conseq", showgenes = F, showrsids = F,
  pos.split = 3e+06, pval.split = 0.125, max.pval = 20)
}
\arguments{
\item{infile}{Input GWAS summary statistics}

\item{outfile}{Output file prefix for the manhattan++ plot}

\item{configfile}{Configuration file}

\item{snpfile}{Table of SNPs to visualize}

\item{drawastiff}{If TRUE draw a Tiff file, if FALSE draw a PDF file}

\item{GWS}{Genome wise significance pvalue threshold (5E-8 by default)}

\item{FDR}{False discovery Rate pvalue threshold (1E-3 by default)}

\item{MAF}{Minor Allele Frequency threshold}

\item{chrname}{Column name for chromosome in GWAS infile}

\item{posname}{Column name for position in GWAS infile}

\item{pvalname}{Column name for pvalue in GWAS infile}

\item{frqname}{column name for allele frequency in GWAS infile}

\item{conseqname}{column name for variant annotation consequence in GWAS infile}

\item{showgenes}{If T shows known genes as bubbles on main manhattan plot, if F show positions of interest as bubbles}

\item{showrsids}{If showgenes is T, then show the rsids, rather than genes}

\item{pos.split}{The bin lengths for positions}

\item{pval.split}{The bin lengths for pvalues}

\item{max.pval}{The maximum pvalue to display}
}
\description{
Generate the manhattan++ plot
}
\details{
For file formats see github page \url{https://github.com/cgrace1978/manhplot}
}
\examples{

\donttest{
library(manhplot)
## Load R.utils for gzip functionality
library(R.utils)

## unzip the data included with this package
gunzip(system.file("extdata","cad.add.160614_manhformat.txt.gz",package = "manhplot"))

infile<-system.file("extdata","cad.add.160614_manhformat.txt",package = "manhplot")
configfile<-system.file("extdata","config.txt", package = "manhplot")
snpfile<-system.file("extdata","56cad.add.160614.variants.txt", package = "manhplot")

manhplusplot(infile = infile,outfile = file.path(tempdir(), "default-plot"), 
               configfile = configfile, snpfile = snpfile)

## zip the data
gzip(system.file("extdata","cad.add.160614_manhformat.txt",package = "manhplot"))
}

}
\author{
Chris Grace
}
