% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{get_data_Stats}
\alias{get_data_Stats}
\alias{get_stats}
\title{A pipe friendly way to get summary stats for exploratory data analysis}
\usage{
get_data_Stats(
  x = NULL,
  func = NULL,
  exclude = NULL,
  na.rm = FALSE,
  na_action = NULL,
  ...
)

get_stats(
  x = NULL,
  func = NULL,
  exclude = NULL,
  na.rm = FALSE,
  na_action = NULL,
  ...
)
}
\arguments{
\item{x}{The data for which stats are required}

\item{func}{The nature of function to apply}

\item{exclude}{What kind of data should be excluded? Use for example c("character","factor") to drop character and factor columns}

\item{na.rm}{Logical. Should NAs be removed. Defaults to FALSE.}

\item{na_action}{If na.rm is set to TRUE, this uses na_replace to replace missing values.}

\item{...}{Other arguments to na_replace
See ?na_replace for details.}
}
\value{
A data.frame object showing the requested stats
}
\description{
A pipe friendly way to get summary stats for exploratory data analysis
}
\details{
A convenient wrapper especially useful for get_mode
}
\examples{
head(get_data_Stats(airquality,mean,na.rm = TRUE,na_action = "get_mode"))
get_stats(airquality,mean,"non_numeric",na.rm = TRUE,na_action = "get_mode")
}
