% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_indirect.R
\name{coef.indirect}
\alias{coef.indirect}
\title{Extract the Indirect Effect or
Conditional Indirect Effect}
\usage{
\method{coef}{indirect}(object, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.}

\item{...}{Optional arguments.
Ignored by the function.}
}
\value{
A scalar: The estimate of the
indirect effect or conditional
indirect effect.
}
\description{
Return the estimate of
the indirect effect in the output of
\code{\link[=indirect_effect]{indirect_effect()}} or or the
conditional indirect in the output of
\code{\link[=cond_indirect]{cond_indirect()}}.
}
\details{
It extracts and returns the
element \code{indirect}. in an object.

If standardized effect is requested
when calling \code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}, the effect
returned is also standardized.
}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ x + w1 + x:w1
m2 ~ x
y  ~ m1 + m2 + x
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE,
           se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

# Examples for indirect_effect():

# Inidrect effect from x through m2 to y
out1 <- indirect_effect(x = "x", y = "y", m = "m2", fit = fit)
out1
coef(out1)

# Conditional Indirect effect from x1 through m1 to y,
# when w1 is 1 SD above mean
hi_w1 <- mean(dat$w1) + sd(dat$w1)
out2 <- cond_indirect(x = "x", y = "y", m = "m1",
                      wvalues = c(w1 = hi_w1), fit = fit)
out2
coef(out2)

}
\seealso{
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect]{cond_indirect()}}.
}
