% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect_proportion.R
\name{coef.indirect_proportion}
\alias{coef.indirect_proportion}
\title{Extract the Proportion of
Effect Mediated}
\usage{
\method{coef}{indirect_proportion}(object, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=indirect_proportion]{indirect_proportion()}}}

\item{...}{Not used.}
}
\value{
A scalar: The proportion of effect
mediated.
}
\description{
Return the proportion
of effect mediated in the output of
\code{\link[=indirect_proportion]{indirect_proportion()}}.
}
\details{
It extracts and returns the
element \code{proportion} in the input
object.
}
\examples{

library(lavaan)
dat <- data_med
head(dat)
mod <-
"
m ~ x + c1 + c2
y ~ m + x + c1 + c2
"
fit <- sem(mod, dat, fixed.x = FALSE)
out <- indirect_proportion(x = "x",
                           y = "y",
                           m = "m",
                           fit = fit)
out
coef(out)

}
\seealso{
\code{\link[=indirect_proportion]{indirect_proportion()}}
}
