% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med_mod_b}
\alias{data_med_mod_b}
\title{Sample Dataset: Simple
Mediation with b-Path Moderated}
\format{
A data frame with 100 rows
and 6 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w}{Moderator. Numeric.}
\item{m}{Mediator. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_b
}
\description{
A simple mediation model
with b-path moderated.
}
\examples{
library(lavaan)
data(data_med_mod_b)
data_med_mod_b$mw <-
 data_med_mod_b$m *
 data_med_mod_b$w
mod <-
"
m ~ a * x + w + c1 + c2
y ~ b * m + x + d * mw + c1 + c2
w ~~ v_w * w
w ~ m_w * 1
ab := a * b
ab_lo := a * (b + d * (m_w - sqrt(v_w)))
ab_hi := a * (b + d * (m_w + sqrt(v_w)))
"
fit <- sem(mod, data_med_mod_b,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 5, 7, 10, 11, 30:32), ]
}
\keyword{datasets}
