% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_cond_indirect_effect.R
\name{print.cond_indirect_effects}
\alias{print.cond_indirect_effects}
\title{Print a
'cond_indirect_effects' Class Object}
\usage{
\method{print}{cond_indirect_effects}(
  x,
  digits = 3,
  annotation = TRUE,
  pvalue = FALSE,
  pvalue_digits = 3,
  se = FALSE,
  ...
)
}
\arguments{
\item{x}{The output of
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{annotation}{Logical. Whether
the annotation after the table of
effects is to be printed. Default is
\code{TRUE.}}

\item{pvalue}{Logical. If \code{TRUE},
asymmetric \emph{p}-values based on
bootstrapping will be printed if
available. Default is \code{FALSE.}}

\item{pvalue_digits}{Number of decimal
places to display for the \emph{p}-values.
Default is 3.}

\item{se}{Logical. If \code{TRUE} and
confidence intervals are available,
the standard errors of the estimates
are also printed. They are simply the
standard deviations of the bootstrap
estimates or Monte Carlo simulated
values, depending on the method used
to form the confidence intervals.}

\item{...}{Other arguments. Not
used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
}
\details{
The \code{print} method of the
\code{cond_indirect_effects}-class object.

If bootstrapping confidence intervals
were requested, this method has the
option to print
\emph{p}-values computed by the
method presented in Asparouhov and Muthén (2021).
Note that these \emph{p}-values are asymmetric
bootstrap \emph{p}-values based on the
distribution of the bootstrap estimates.
They not computed based on the
distribution under the null hypothesis.

For a \emph{p}-value of \emph{a}, it means that
a 100(1 - \emph{a})\% bootstrapping confidence
interval
will have one of its limits equal to
0. A confidence interval
with a higher confidence level will
include zero, while a confidence
interval with a lower confidence level
will exclude zero.
}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ a1 * x  + d1 * w1 + e1 * x:w1
m2 ~ a2 * x
y  ~ b1 * m1 + b2 * m2 + cp * x
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE)

# Conditional effects from x to m1 when w1 is equal to each of the default levels
cond_indirect_effects(x = "x", y = "m1",
                      wlevels = "w1", fit = fit)

# Conditional Indirect effect from x1 through m1 to y,
# when w1 is equal to each of the default levels
out <- cond_indirect_effects(x = "x", y = "y", m = "m1",
                      wlevels = "w1", fit = fit)
out

print(out, digits = 5)

print(out, annotation = FALSE)


}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
}
