% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_indirect_effects_subset.R
\name{subsetting_cond_indirect_effects}
\alias{subsetting_cond_indirect_effects}
\alias{[.cond_indirect_effects}
\title{Extraction Methods for
'cond_indirect_effects' Outputs}
\usage{
\method{[}{cond_indirect_effects}(x, i, j, drop = if (missing(i)) TRUE else length(j) == 1)
}
\arguments{
\item{x}{A
'cond_indirect_effects'-class object.}

\item{i}{A numeric vector of row
number(s), a character vector of row
name(s), or a logical vector of
row(s) to be selected.}

\item{j}{A numeric vector of column
number(s), a character vector of
column name(s), or a logical vector
of column(s) to be selected.}

\item{drop}{Whether dropping a
dimension if it only have one
row/column.}
}
\value{
A
'cond_indirect_effects'-class object.
See \code{\link[=cond_indirect_effects]{cond_indirect_effects()}} for
details on this class.
}
\description{
For subsetting a
'cond_indirect_effects'-class object.
}
\details{
Customized \code{[} for
'cond_indirect_effects'-class
objects, to ensure that these
operations work as they would be on a
data frame object, while information
specific to conditional effects is
modified correctly.
}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ x  + w1 + x:w1
m2 ~ m1
y  ~ m2 + x + w4 + m2:w4
"
fit <- sem(mod, dat, meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

# Examples for cond_indirect():

# Conditional effects from x to m1 when w1 is equal to each of the levels
out1 <- cond_indirect_effects(x = "x", y = "m1",
                      wlevels = "w1", fit = fit)
out1[2, ]

# Conditional Indirect effect from x1 through m1 to y,
# when w1 is equal to each of the levels
out2 <- cond_indirect_effects(x = "x", y = "y", m = c("m1", "m2"),
                      wlevels = c("w1", "w4"), fit = fit)
out2[c(1, 3), ]

}
