% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_delta_med.R
\name{print.delta_med}
\alias{print.delta_med}
\title{Print a 'delta_med' Class Object}
\usage{
\method{print}{delta_med}(x, digits = 3, level = NULL, full = FALSE, boot_type, ...)
}
\arguments{
\item{x}{A \code{delta_med}-class object.}

\item{digits}{The number of digits
after the decimal. Default is 3.}

\item{level}{The level of confidence
of bootstrap confidence interval,
if requested when created. If \code{NULL},
the default, the level requested when
calling \code{\link[=delta_med]{delta_med()}} is used. If
not null, then this level will be
used.}

\item{full}{Logical. Whether
additional information will be printed.
Default is \code{FALSE}.}

\item{boot_type}{If bootstrap
confidence interval is to be formed,
the type of bootstrap confidence
interval. The supported types
are \code{"perc"} (percentile bootstrap
confidence interval, the recommended
method) and \code{"bc"}
(bias-corrected, or BC, bootstrap
confidence interval). If not supplied,
the stored \code{boot_type} will be used.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
\code{x} is returned invisibly. Called
for its side effect.
}
\description{
Print the content of
a \code{delta_med}-class object.
}
\details{
It prints the output of
\code{delta_med()}, which is a
\code{delta_med}-class object.
}
\examples{

library(lavaan)
dat <- data_med
mod <-
"
m ~ x
y ~ m + x
"
fit <- sem(mod, dat)
dm <- delta_med(x = "x",
                y = "y",
                m = "m",
                fit = fit)
dm
print(dm, full = TRUE)

# Call do_boot() to generate
# bootstrap estimates
# Use 2000 or even 5000 for R in real studies
# Set parallel to TRUE in real studies for faster bootstrapping
boot_out <- do_boot(fit,
                    R = 45,
                    seed = 879,
                    parallel = FALSE,
                    progress = FALSE)
# Remove 'progress = FALSE' in practice
dm_boot <- delta_med(x = "x",
                     y = "y",
                     m = "m",
                     fit = fit,
                     boot_out = boot_out,
                     progress = FALSE)
dm_boot
confint(dm_boot)
confint(dm_boot,
        level = .90)

}
\seealso{
\code{\link[=delta_med]{delta_med()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
