% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_format.R
\name{manip_reformat}
\alias{manip_reformat}
\alias{to_acyclic}
\alias{to_anti}
\alias{to_redirected}
\alias{to_reciprocated}
\alias{to_directed}
\title{Modifying network formats}
\usage{
to_acyclic(.data)

to_anti(.data)

to_redirected(.data)

to_reciprocated(.data)

to_directed(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions reformat manynet-consistent data.
\itemize{
\item \code{to_acyclic()} reformats network data to an acyclic graph.
\item \code{to_anti()} reformats network data into its complement, where only ties \emph{not} present in the original network
are included in the new network.
\item \code{to_redirected()} reformats the direction of directed network data, flipping any existing direction.
\item \code{to_reciprocated()} reformats directed network data such that every directed tie is reciprocated.
}

Unlike the \verb{as_*()} group of functions,
these functions always return the same class as they are given,
only transforming these objects' properties.
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_acyclic \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_anti \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_reciprocated \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_redirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
}
}
\section{Functions}{
\itemize{
\item \code{to_redirected()}: Returns an object that has any edge direction transposed,
or flipped, so that senders become receivers and receivers become senders.
This essentially has no effect on undirected networks or reciprocated ties.

\item \code{to_reciprocated()}: Returns an object where all ties are reciprocated.

}}
\examples{
to_anti(ison_southern_women)
#graphr(to_anti(ison_southern_women))
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_deformat}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_nodes}},
\code{\link{manip_paths}},
\code{\link{manip_permutation}},
\code{\link{manip_preformat}},
\code{\link{manip_project}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
