% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_gridmap.R
\name{esp_get_gridmap}
\alias{esp_get_gridmap}
\alias{esp_get_hex_prov}
\alias{esp_get_hex_ccaa}
\alias{esp_get_grid_prov}
\alias{esp_get_grid_ccaa}
\title{Get a \code{sf} hexbin or squared polygon of Spain}
\usage{
esp_get_hex_prov(prov = NULL)

esp_get_hex_ccaa(ccaa = NULL)

esp_get_grid_prov(prov = NULL)

esp_get_grid_ccaa(ccaa = NULL)
}
\arguments{
\item{prov}{A vector of names and/or codes for provinces
or \code{NULL} to get all the provinces. See \strong{Details}.}

\item{ccaa}{A vector of names and/or codes for autonomous communities
or \code{NULL} to get all the autonomous communities. See \strong{Details}.}
}
\value{
A \code{sf} POLYGON object.
}
\description{
Loads a hexbin map (\code{sf} object) or a map of squares with the boundaries of
the provinces or autonomous communities of Spain.
}
\details{
Hexbin or grid map has an advantage over usual choropleth maps.
In choropleths, a large polygon data looks more emphasized just because
of its size, what introduces a bias. Here with hexbin, each region is
represented equally dismissing the bias.

You can use and mix names, ISO codes, "codauto"/"cpro" codes (see
\link{esp_codelist}) and NUTS codes of different levels.

When using a code corresponding of a higher level (e.g.
\code{esp_get_prov("Andalucia")}) all the corresponding units of that level are
provided (in this case , all the provinces of Andalucia).

Results are provided in \strong{EPSG:4258}, use \code{\link[sf:st_transform]{sf::st_transform()}}
to change the projection.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\section{Displacing the Canary Islands}{
While \code{moveCAN} is useful for visualization, it would alter the actual
geographic position of the Canary Islands. When using the output for
spatial analysis or using tiles (e.g. with \code{\link[=esp_getTiles]{esp_getTiles()}} or
\code{\link[=addProviderEspTiles]{addProviderEspTiles()}})  this option should be set to \code{FALSE} in order to
get the actual coordinates, instead of the modified ones.
}

\examples{


esp <- esp_get_country()
hexccaa <- esp_get_hex_ccaa()

library(tmap)


tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(hexccaa) +
  tm_polygons("codauto", alpha = 0.6, legend.show = FALSE) +
  tm_shape(hexccaa) +
  tm_text("label") +
  tm_layout(main.title = "Hexbin: CCAA")



hexprov <- esp_get_hex_prov()

tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(hexprov) +
  tm_polygons("cpro", alpha = 0.6, legend.show = FALSE) +
  tm_shape(hexprov) +
  tm_text("label") +
  tm_layout(main.title = "Hexbin: Provinces")



gridccaa <- esp_get_grid_ccaa()

tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(gridccaa) +
  tm_polygons("codauto", alpha = 0.6, legend.show = FALSE) +
  tm_shape(gridccaa) +
  tm_text("label") +
  tm_layout(main.title = "Grid: CCAA")

gridprov <- esp_get_grid_prov()

tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(gridprov) +
  tm_polygons("cpro", alpha = 0.6, legend.show = FALSE) +
  tm_shape(gridprov) +
  tm_text("label") +
  tm_layout(main.title = "Grid: Provinces")
}
\seealso{
Other political: 
\code{\link{esp_codelist}},
\code{\link{esp_get_can_box}()},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()}
}
\concept{political}
