% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{mb_access_token}
\alias{mb_access_token}
\alias{get_mb_access_token}
\alias{list_tokens}
\title{Install or retrieve a Mapbox access token in your .Renviron for repeated use}
\usage{
mb_access_token(token, overwrite = FALSE, install = FALSE)

get_mb_access_token(
  token = NULL,
  default = c("MAPBOX_PUBLIC_TOKEN", "MAPBOX_SECRET_TOKEN"),
  secret_required = FALSE
)

list_tokens(
  username,
  default = NULL,
  limit = NULL,
  sortby = "created",
  usage = NULL,
  access_token = NULL
)
}
\arguments{
\item{token}{A Mapbox access token; can be public (starting with 'pk') or
secret (starting with 'sk') scope, which the function will interpret for
you.}

\item{overwrite}{Whether or not to overwrite an existing Mapbox access token.
Defaults to \code{FALSE}.}

\item{install}{if \code{TRUE}, will install the key in your \code{.Renviron} file for use
in future sessions. Defaults to \code{FALSE}.}

\item{default}{If \code{TRUE}, will only include the default token for an account.
If \code{FALSE}, will include all other tokens except for the default. Defaults
to \code{NULL}.}

\item{secret_required}{If \code{TRUE}, a secret token is required. If \code{FALSE}, the
default token is provided first and the other token provided second if the
first is unavailable.}

\item{username}{The Mapbox username for which you'd like to list access
tokens.}

\item{limit}{The maximum number of tokens to return. Defaults to \code{NULL}.}

\item{sortby}{How to sort the returned tokens; one of \code{"created"} or
\code{"modified"}.}

\item{usage}{If \code{"pk"}, returns only public tokens; if \code{"sk"}, returns only
secret tokens. Defaults to \code{NULL}, which returns all tokens in the scope of
the supplied access token.}

\item{access_token}{Your Mapbox access token. If left \code{NULL}, will first check
to see if you have a secret token stored in .Renviron, then a public token.}
}
\value{
A tibble of information about tokens in your Mapbox account.
}
\description{
See the Mapbox API documentation for \href{https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes}{more information on access tokens and token scopes}.
}
\examples{
\dontrun{
my_token <- "..." # The token generated from your Mapbox account
mb_access_token(my_token, install = TRUE)
Sys.getenv("MAPBOX_PUBLIC_TOKEN")

get_mb_access_token()
}
\dontrun{

token_list <- list_tokens(
  username = "kwalkertcu", # You would use your own username here
  limit = 10,
  sortby = "modified" #'
)
}

}
