% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_screengrid.R
\name{add_screengrid}
\alias{add_screengrid}
\title{Add Screengrid}
\usage{
add_screengrid(map, data = get_map_data(map), lon = NULL, lat = NULL,
  polyline = NULL, weight = NULL, colour_range = viridisLite::viridis(6),
  opacity = 0.8, cell_size = 50, layer_id, digits = 6)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer}

\item{lon}{column containing longitude values}

\item{lat}{column containing latitude values}

\item{polyline}{column of \code{data} containing the polylines}

\item{weight}{the weight of each value}

\item{colour_range}{vector of 6 hex colours}

\item{opacity}{opacity of cells. Value between 0 and 1}

\item{cell_size}{size of grid squares in pixels}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}
}
\description{
The Screen Grid Layer takes in an array of latitude and longitude coordinated points,
aggregates them into histogram bins and renders as a grid
}
\examples{
\donttest{

## You need a valid access token from Mapbox
key <- 'abc'

df <- read.csv(paste0(
'https://raw.githubusercontent.com/uber-common/deck.gl-data/master/',
'examples/3d-heatmap/heatmap-data.csv'
))

df$weight <- sample(1:10, size = nrow(df), replace = T)

mapdeck( token = key, style = mapdeck_style('dark'), pitch = 45 ) \%>\%
add_screengrid(
  data = df
  , lat = "lat"
  , lon = "lng"
  , weight = "weight",
  , layer_id = "screengrid_layer"
  , cell_size = 10
  , opacity = 0.3
)
}

}
