% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_text.R
\name{add_text}
\alias{add_text}
\title{Add Text}
\usage{
add_text(
  map,
  data = get_map_data(map),
  text,
  lon = NULL,
  lat = NULL,
  polyline = NULL,
  fill_colour = NULL,
  fill_opacity = NULL,
  size = NULL,
  angle = NULL,
  anchor = NULL,
  alignment_baseline = NULL,
  billboard = TRUE,
  font_family = "Monaco, monospace",
  font_weight = "normal",
  tooltip = NULL,
  layer_id = NULL,
  id = NULL,
  auto_highlight = FALSE,
  highlight_colour = "#AAFFFFFF",
  palette = "viridis",
  na_colour = "#808080FF",
  legend = FALSE,
  legend_options = NULL,
  legend_format = NULL,
  update_view = TRUE,
  focus_layer = FALSE,
  digits = 6,
  transitions = NULL,
  brush_radius = NULL
)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be
EPSG:4326 (WGS 84) coordinate system}

\item{text}{column of \code{data} containing the text. The data must be a character.}

\item{lon}{column containing longitude values}

\item{lat}{column containing latitude values}

\item{polyline}{optional column of \code{data} containing the polylines, if using encoded polylines}

\item{fill_colour}{column of \code{data} or hex colour for the fill colour.
If using a hex colour, use either a single value, or a vector the same length as \code{data}}

\item{fill_opacity}{Either a string specifying the column of \code{data}
containing the opacity of each shape, or a single value in [0,255], or [0, 1),
to be applied to all the shapes. Default 255. If a hex-string is used as the
colour, this argument is ignored and you should include the alpha on the hex string}

\item{size}{column of \code{data} containing the size of the text. Default 32}

\item{angle}{column of \code{data} containging the angle of the text. Default 0}

\item{anchor}{column of \code{data} containing the anchor of the text. One of
'start', 'middle' or 'end'}

\item{alignment_baseline}{column of \code{data} containing the alignment. One of
'top', 'center' or 'bottom'}

\item{billboard}{logical indicating if the text always faces the camera (TRUE) or
if it always faces up (FALSE)}

\item{font_family}{specifies a prioritised list of one or more font family names and/or
generic family names. Follow the specifics for CSS font-family
\url{https://developer.mozilla.org/en-US/docs/Web/CSS/font-family}}

\item{font_weight}{specifies the font weight. Follow the specifics for CSS font-weight
\url{https://htmldog.com/references/css/properties/font-weight/}}

\item{tooltip}{variable of \code{data} containing text or HTML to render as a tooltip}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{id}{an id value in \code{data} to identify layers when interacting in Shiny apps.}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix must have at least 5 rows, and 3 or 4 columns of values between [0, 255],
where the 4th column represents the alpha. You can use a named list to specify a different
palette for different colour options (where available),
 e.g. list(fill_colour = "viridis", stroke_colour = "inferno")}

\item{na_colour}{hex string colour to use for NA values}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{legend_format}{A list containing functions to apply to legend values. See section legend}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{digits}{number of digits for rounding coordinates}

\item{transitions}{list specifying the duration of transitions.}

\item{brush_radius}{radius of the brush in metres. Default NULL. If supplied,
the arcs will only show if the origin or destination are within the radius of the mouse.
If NULL, all arcs are displayed}
}
\description{
The Text Layer renders text labels on the map
}
\details{
\code{add_text} supports POINT and MULTIPOINT sf objects
}
\section{transitions}{


The transitions argument lets you specify the time it will take for the shapes to transition
from one state to the next. Only works in an interactive environment (Shiny)
and on WebGL-2 supported browsers and hardware.

The time is in milliseconds

Available transitions for text

list(
position = 0,
fill_colour = 0,
angle = 0,
size = 0
)
}

\section{legend}{


The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
  \item{digits - number to round the legend values to}
}

If the layer allows different fill and stroke colours, you can use different options for each. See examples in \link{add_arc}.

The \code{legend_format} can be used to control the format of the values in the legend.
This should be a named list, where the names are one of
\itemize{
  \item{fill_colour}
  \item{stroke_colour}
}

depending on which type of colouring the layer supports.

The list elements must be functions to apply to the values in the legend.
}

\section{id}{


The \code{id} is returned to your R session from an interactive shiny environment
by observing layer clicks. This is useful for returning the data.frame row relating to the
cliked shape.

From within a shiny server you would typically use \code{ observeEvent({input$map_arc_click})},
where 'map' is the map_id supplied to \code{mapdeckOutput()}, and 'arc' is the layer
you are clicking on
}

\examples{

\donttest{

## You need a valid access token from Mapbox
key <- 'abc'
set_token( key )

mapdeck(
  style = mapdeck_style('dark')
) \%>\%
  add_text(
    data = capitals
    , lon = 'lon'
    , lat = 'lat'
    , fill_colour = 'country'
    , text = 'capital'
    , layer_id = 'text'
  )
}

}
