% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mapfuser.R
\name{plot.mapfuser}
\alias{plot.mapfuser}
\title{Visualise mapfuser object data}
\usage{
\method{plot}{mapfuser}(x, which = c("mapnetwork", "mst", "compare_maps",
  "single_map", "mareymap", "recombination_rate"), chr = NULL, maps = NULL,
  ...)
}
\arguments{
\item{x}{A mapfuser object with a reference map loaded and either a consensus map created with mapfuser or a genetic loaded with read_maps}

\item{which}{Dataset to visualize:
1) which = "mapnetwork", "mst". Plots the connection in terms of overlapping markers between maps as mapnetwork and the corresponding minimum spanning tree using the inverse of the number of anchors markers as edge weight
2) which = "compare_maps". Plots a simple scatterplot between two genetic maps,
3) which = "single_map". Plot a single map per chromosome in mapchart style
4) which = "marey_map". Plot the relationship between centi Morgan positions and physical genome position along with the fitted Penalized spline for each chromosomes
5) which = "recombination_rate". Plot the recombination rate in centi Morgan per mega base pair along the physical genome.}

\item{chr}{The chromosomes to plot, mapnetwork and mst is single chromosome only}

\item{maps}{Name or names of the maps to plot in case which = "mareymap", "single_map", or "compare_maps"}

\item{...}{ingored in function call}
}
\value{
A plot.igraph object in the case of "mst" or "mapnetwork" or an interactive ggplotly object otherwise
}
\description{
Visualise mapfuser object data
}
\examples{
\dontshow{
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "-1", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE, type = "delim")
MF.obj <- map_qc(MF.obj)
plot(x = MF.obj, which = "mapnetwork", chr = 1)
}
\dontrun{
plot(x = MF.obj, which = "mapnetwork", chr = 1)
plot(x = MF.obj, which = "mst", chr = 1)
plot(x = MF.obj, which = "single_map", maps = "consensus")
plot(x = MF.obj, which = "compare_maps", maps = c("Col-0_Cvi-0.csv","Col-0_Sha.csv"), chr = 1:3)
plot(x = MF.obj, which = "mareymap", maps = "Col-0_Bur-0.csv", chr = 1:5)
plot(x = MF.obj, which = "mareymap", maps = "consensus", chr = 1:5)
plot(x = MF.obj, which = "recombination_rate", chr = 1:5)
}
}
\author{
Dennis van Muijen
}
