% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_rendered_features.R
\name{get_queried_features}
\alias{get_queried_features}
\title{Get queried features from a map as an sf object}
\usage{
get_queried_features(map)
}
\arguments{
\item{map}{A map object (mapboxgl, maplibre) or proxy object (mapboxgl_proxy, maplibre_proxy,
mapboxgl_compare_proxy, maplibre_compare_proxy)}
}
\value{
An sf object containing the queried features, or an empty sf object if no features were found
}
\description{
This function retrieves the results of a feature query triggered by \code{query_rendered_features()}.
It returns the features as a deduplicated sf object. Note that only features that were
visible in the viewport at the time of the query will be included.
}
\examples{
\dontrun{
# In a Shiny server function:
observeEvent(input$query_button, {
    proxy <- maplibre_proxy("map")
    query_rendered_features(proxy, layer_id = "counties")
    features <- get_queried_features(proxy)
    print(nrow(features))
})
}
}
