% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio.R
\name{read_portfolio}
\alias{read_portfolio}
\title{Reading a portfolio object from disk}
\usage{
read_portfolio(file, ...)
}
\arguments{
\item{file}{A character vector pointing to a GeoPackage that has been
previously written to disk via \code{write_portfolio()}}

\item{...}{Additional arguments supplied to \code{st_read()}}
}
\value{
An sf object object with nested list columns for every indicator
table found in the GeoPackage source file.
}
\description{
This function can be used to read a portfolio object that was previously
written to disk via \code{write_portfolio()} back into R as an \code{sf} object.
It should specifically be directed against a GeoPackage which was the output
of \code{write_portfolio()}, otherwise the function is very likely to fail.
All available indicators will be read back into R as nested list columns
reflecting the output once \code{calc_indicators()} has been called.
}
\details{
\strong{Important Note}
Portfolio-wide attributes that were specified via \code{init_portfolio()} will
not be reconstructed. The reason is that users most likely exported to a
GeoPackage in order to share their data, thus the file is very likely to be
opened on a different machine / in a different working directory. Users can
simply apply \code{init_portfolio()} on the object to re-set these attributes.
}
\keyword{function}
